/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.fluid;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.IdentityHashMap;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.fluids.MLBuiltinSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidColors;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.misc.SidedInstance;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.fluid.fabric.SoftFluidInternalImpl;
import net.mehvahdjukaar.moonlight.core.network.ClientBoundFinalizeFluidsMessage;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_3222;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class SoftFluidInternal {
    private static final SidedInstance<Map<class_3611, class_6880<SoftFluid>>> FLUID_MAP = SidedInstance.of(r -> {
        IdentityHashMap<class_3611, class_6880<SoftFluid>> m = new IdentityHashMap<class_3611, class_6880<SoftFluid>>();
        SoftFluidInternal.populateFluidSlaveMap(r, m);
        return m;
    });
    private static final SidedInstance<Map<class_1792, class_6880<SoftFluid>>> ITEM_MAP = SidedInstance.of(r -> {
        IdentityHashMap<class_1792, class_6880<SoftFluid>> m = new IdentityHashMap<class_1792, class_6880<SoftFluid>>();
        SoftFluidInternal.populateItemSlaveMap(r, m);
        return m;
    });

    public static class_6880<SoftFluid> fromVanillaFluid(class_3611 fluid, class_7225.class_7874 registryAccess) {
        return FLUID_MAP.get(registryAccess).get(fluid);
    }

    public static class_6880<SoftFluid> fromVanillaItem(class_1792 item, class_7225.class_7874 registryAccess) {
        return ITEM_MAP.get(registryAccess).get(item);
    }

    private static void populateFluidSlaveMap(class_7225.class_7874 registryAccess, Map<class_3611, class_6880<SoftFluid>> fluidMap) {
        fluidMap.clear();
        for (class_6880.class_6883 h : SoftFluidRegistry.get(registryAccess).method_42017().toList()) {
            SoftFluid s = (SoftFluid)h.comp_349();
            if (!s.isEnabled()) continue;
            for (class_6880 eq : s.getEquivalentFluids()) {
                class_3611 value = (class_3611)eq.comp_349();
                if (value == class_3612.field_15906) {
                    Moonlight.LOGGER.error("!!Invalid fluid for fluid. This is a bug! {}", (Object)h);
                    if (PlatHelper.isDev()) {
                        throw new AssertionError((Object)("Invalid fluid for fluid. This is a bug! " + String.valueOf(h)));
                    }
                }
                fluidMap.put(value, (class_6880<SoftFluid>)h);
            }
            s.getEquivalentFluids().forEach(f -> fluidMap.put((class_3611)f.comp_349(), (class_6880<SoftFluid>)h));
        }
    }

    private static void populateItemSlaveMap(class_7225.class_7874 registryAccess, Map<class_1792, class_6880<SoftFluid>> itemMap) {
        itemMap.clear();
        for (class_6880.class_6883 h : SoftFluidRegistry.get(registryAccess).method_42017().toList()) {
            SoftFluid s = (SoftFluid)h.comp_349();
            if (!s.isEnabled()) continue;
            s.getContainerList().getPossibleFilled().forEach(i -> {
                if (i != class_1802.field_8574 || !MLBuiltinSoftFluids.WATER.is((class_6880<SoftFluid>)h)) {
                    if (i == class_1802.field_8162) {
                        Moonlight.LOGGER.error("!!Invalid item for fluid. This is a bug! {}", (Object)h);
                        if (PlatHelper.isDev()) {
                            throw new AssertionError((Object)("Invalid item for fluid. This is a bug! " + String.valueOf(h)));
                        }
                    }
                    itemMap.put((class_1792)i, (class_6880<SoftFluid>)h);
                }
            });
        }
    }

    public static void init() {
        RegHelper.registerDataPackRegistry(SoftFluidRegistry.KEY, SoftFluid.CODEC, SoftFluid.CODEC);
    }

    public static void postInitClient(class_5455 ra) {
        FLUID_MAP.get((class_7225.class_7874)ra);
        ITEM_MAP.get((class_7225.class_7874)ra);
        class_2378<SoftFluid> reg = SoftFluidRegistry.get(ra);
        for (SoftFluid f : reg) {
            f.afterInit();
        }
        SoftFluidColors.refreshParticleColors(reg);
    }

    public static void onDataSyncToPlayer(class_3222 player, boolean isJoined) {
        if (isJoined) {
            NetworkHelper.sendToClientPlayer(player, new ClientBoundFinalizeFluidsMessage());
        }
    }

    public static void doPostInitServer(class_5455 ra) {
        FLUID_MAP.get((class_7225.class_7874)ra);
        ITEM_MAP.get((class_7225.class_7874)ra);
        SoftFluidInternal.registerExistingVanillaFluids(ra, FLUID_MAP.get((class_7225.class_7874)ra), ITEM_MAP.get((class_7225.class_7874)ra));
        for (SoftFluid f : SoftFluidRegistry.get(ra)) {
            f.afterInit();
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerExistingVanillaFluids(class_5455 ra, Map<class_3611, class_6880<SoftFluid>> fluidMap, Map<class_1792, class_6880<SoftFluid>> itemMap) {
        void var2_2;
        void var1_1;
        SoftFluidInternalImpl.registerExistingVanillaFluids(ra, (Map<class_3611, class_6880<SoftFluid>>)var1_1, (Map<class_1792, class_6880<SoftFluid>>)var2_2);
    }
}

