/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core;

import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.mehvahdjukaar.moonlight.api.events.IDropItemOnDeathEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.integration.HardcodedBlockTypes;
import net.mehvahdjukaar.moonlight.api.misc.DynamicHolder;
import net.mehvahdjukaar.moonlight.api.misc.HolderReference;
import net.mehvahdjukaar.moonlight.api.misc.RegistryAccessJsonReloadListener;
import net.mehvahdjukaar.moonlight.api.misc.WorldSavedDataType;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.trades.ItemListingManager;
import net.mehvahdjukaar.moonlight.api.util.DispenserHelper;
import net.mehvahdjukaar.moonlight.core.CommonConfigs;
import net.mehvahdjukaar.moonlight.core.MoonlightClient;
import net.mehvahdjukaar.moonlight.core.commands.BackCommand;
import net.mehvahdjukaar.moonlight.core.commands.ModCommands;
import net.mehvahdjukaar.moonlight.core.fluid.SoftFluidInternal;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.mehvahdjukaar.moonlight.core.misc.VillagerAIInternal;
import net.mehvahdjukaar.moonlight.core.network.ClientBoundSyncWorldDataMessage;
import net.mehvahdjukaar.moonlight.core.network.ModNetworking;
import net.mehvahdjukaar.moonlight.core.pack.DynamicResourcesInternals;
import net.mehvahdjukaar.moonlight.core.set.BlockSetInternal;
import net.mehvahdjukaar.moonlight.core.set.BlocksColorInternal;
import net.mehvahdjukaar.moonlight.core.set.DebugBlockTypes;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3279;
import net.minecraft.class_3285;
import net.minecraft.class_5321;
import net.minecraft.class_5352;
import net.minecraft.class_5455;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_8580;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class Moonlight {
    public static final String MOD_ID = "moonlight";
    public static final Logger LOGGER = LogManager.getLogger((String)"Moonlight");
    public static final boolean HAS_BEEN_INIT = true;
    public static final ThreadLocal<WeakReference<class_5455>> EARLY_REGISTRY_ACCESS = new ThreadLocal();
    private static final Set<String> DEPENDENTS = new HashSet<String>();
    private static boolean verboseLogging = false;

    public static class_2960 res(String name) {
        return class_2960.method_60655((String)MOD_ID, (String)name);
    }

    public static void commonInit() {
        CommonConfigs.init();
        BlockSetInternal.registerBlockSetDefinition(WoodTypeRegistry.INSTANCE);
        BlockSetInternal.registerBlockSetDefinition(LeavesTypeRegistry.INSTANCE);
        HardcodedBlockTypes.init();
        MoonlightRegistry.init();
        ItemListingManager.init();
        ModNetworking.init();
        ModCommands.init();
        DynamicResourcesInternals.init();
        VillagerAIInternal.init();
        MapDataInternal.init();
        SoftFluidInternal.init();
        RegHelper.addDynamicDispenserBehaviorRegistration(Moonlight::registerBuiltinFluidBehavior);
        PlatHelper.addCommonSetup(Moonlight::commonSetup);
        PlatHelper.addReloadableCommonSetup(Moonlight::afterDataReloadOrDataSync);
        PlatHelper.addServerReloadListener(ItemListingManager::new, Moonlight.res("villager_trade"));
        Moonlight.addGlobalDatapackLoader();
        if (PlatHelper.getPhysicalSide().isClient()) {
            MoonlightClient.initClient();
        }
        RegHelper.addItemsToTabsRegistration(event -> {
            if (event.getTab().method_47310()) {
                event.add((class_5321<class_1761>)class_7706.field_41063, (class_1935)MoonlightRegistry.SPAWN_BOX_BLOCK.get());
            }
        });
        BlockSetAPI.addDynamicRegistration(MOD_ID, r -> {}, class_7923.field_41175);
    }

    private static void addGlobalDatapackLoader() {
        String globalPacksDir = CommonConfigs.GLOBAL_DATAPACKS_DIR.get();
        if (!globalPacksDir.isEmpty()) {
            Path path = PlatHelper.getGamePath().resolve(globalPacksDir);
            class_8580 validator = new class_8580(a -> true);
            RegHelper.registerResourcePackSource(class_3264.field_14190, (class_3285)new class_3279(path, class_3264.field_14190, class_5352.field_25347, validator));
            try {
                path.toFile().mkdirs();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void commonSetup() {
        BlocksColorInternal.setup();
        if (PlatHelper.getPhysicalSide().isClient()) {
            MoonlightClient.setupClient();
        }
        if (CommonConfigs.EXTRA_DEBUG.get().booleanValue() || PlatHelper.isDev()) {
            DebugBlockTypes.writeToFile();
        }
    }

    public static void onPlayerCloned(class_1657 oldPlayer, class_1657 newPlayer, boolean wasDeath) {
        class_2338 oldPos = oldPlayer.method_24515();
        class_5321 oldDim = oldPlayer.method_37908().method_27983();
        BackCommand.onTeleported((class_1297)newPlayer, oldPos, (class_5321<class_1937>)oldDim);
        if (wasDeath && !oldPlayer.method_37908().method_8450().method_8355(class_1928.field_19389)) {
            class_1661 inv = oldPlayer.method_31548();
            int i = 0;
            for (class_1799 v : inv.field_7547) {
                if (v != class_1799.field_8037) {
                    IDropItemOnDeathEvent e = IDropItemOnDeathEvent.create(v, oldPlayer, false);
                    MoonlightEventsHelper.postEvent(e, IDropItemOnDeathEvent.class);
                    if (e.isCanceled()) {
                        newPlayer.method_31548().method_5447(i, e.getReturnItemStack());
                    }
                }
                ++i;
            }
        }
    }

    public static void onDataSyncToPlayer(class_3222 player, boolean joined) {
        if (joined) {
            SoftFluidInternal.onDataSyncToPlayer(player, true);
        }
        class_1937 world = player.method_37908();
        for (WorldSavedDataType type : MoonlightRegistry.WORLD_SAVED_DATA_TYPE_REGISTRY) {
            Object data = type.getData(world);
            NetworkHelper.sendToClientPlayer(player, new ClientBoundSyncWorldDataMessage(data));
        }
    }

    public static void setServerRegistryAccess(class_5455.class_6890 registryAccess) {
        EARLY_REGISTRY_ACCESS.set(new WeakReference<class_5455.class_6890>(registryAccess));
    }

    private static void afterDataReloadOrDataSync(class_5455 registryAccess, boolean client) {
        EARLY_REGISTRY_ACCESS.set(new WeakReference<class_5455>(registryAccess));
        RegistryAccessJsonReloadListener.runReloads(registryAccess);
        DynamicResourcesInternals.clearAfterReload(class_3264.field_14190);
        DynamicHolder.clearCache();
        HolderReference.clearCache();
        DispenserHelper.reload(registryAccess, client);
    }

    public static void beforeServerStart(class_5455 ra) {
        SoftFluidInternal.doPostInitServer(ra);
    }

    public static void assertInitPhase() {
        if (!PlatHelper.isInitializing() && PlatHelper.getPlatform().isForge()) {
            throw new AssertionError((Object)"Method has to be called during main mod initialization phase. Client and Server initializer are not valid, you must call in the main one");
        }
    }

    public static boolean isInitPhase() {
        return PlatHelper.isInitializing() || !PlatHelper.getPlatform().isForge();
    }

    public static void assertAfterInitPhase() {
        if (PlatHelper.isInitializing()) {
            throw new AssertionError((Object)"Method has to be called after main mod initialization phase. Client and Server initializer are not valid, you must call in the main one");
        }
    }

    @ApiStatus.Internal
    public static void addDependent(String modId) {
        if (!Set.of("minecraft", "neoforge", "fabric").contains(modId)) {
            DEPENDENTS.add(modId);
        }
    }

    public static Set<String> getDependents() {
        return Set.copyOf(DEPENDENTS);
    }

    public static boolean isDependant(String modId) {
        return DEPENDENTS.contains(modId);
    }

    public static void crashIfInDev(String message) {
        if (PlatHelper.isDev()) {
            throw new RuntimeException(message);
        }
        LOGGER.error(message);
    }

    public static void crashIfInDev() {
        Moonlight.crashIfInDev("");
    }

    public static void logIfInDev(String s) {
        if (PlatHelper.isDev()) {
            LOGGER.error(s);
        }
    }

    public static void registerBuiltinFluidBehavior(DispenserHelper.Event event) {
        HashSet<class_1792> itemSet = new HashSet<class_1792>();
        for (SoftFluid f : SoftFluidRegistry.get(event.getRegistryAccess())) {
            List<FluidContainerList.Category> categories = f.getContainerList().getCategories();
            for (FluidContainerList.Category c : categories) {
                class_1792 empty = c.getEmptyContainer();
                if (empty != class_1802.field_8162 && !itemSet.contains(empty)) {
                    event.register(new DispenserHelper.FillFluidHolderBehavior(empty));
                    itemSet.add(empty);
                }
                for (class_1792 full : c.getFilledItems()) {
                    if (full == class_1802.field_8162 || itemSet.contains(full)) continue;
                    event.register(new DispenserHelper.FillFluidHolderBehavior(full));
                    itemSet.add(full);
                }
            }
        }
    }

    public static void setVerboseLogging(boolean b) {
        verboseLogging = b;
    }

    public static boolean isVerboseLogging() {
        return verboseLogging;
    }
}

