/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.misc.MapRegistry;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.util.INamedSupplier;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.CompatHandler;
import net.mehvahdjukaar.moonlight.core.integration.PolymerCompat;
import net.mehvahdjukaar.moonlight.core.set.BlockSetInternal;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2359;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockTypeRegistry<T extends BlockType>
implements class_2359<T> {
    protected boolean frozen = false;
    private final String name;
    private final List<BlockType.SetFinder<T>> finders = new ArrayList<BlockType.SetFinder<T>>();
    private final Set<class_2960> notInclude = new HashSet<class_2960>();
    protected final MapRegistry<T> valuesReg;
    private final Class<T> typeClass;
    private final Object2ObjectOpenHashMap<Object, T> childrenToType = new Object2ObjectOpenHashMap();
    private final class_9139<ByteBuf, T> streamCodecSlow;
    @Deprecated(forRemoval=true)
    boolean isBeingFrozenHack = false;

    public static Codec<BlockTypeRegistry<?>> getRegistryCodec() {
        return BlockSetInternal.getRegistriesCodec();
    }

    public static class_9139<ByteBuf, BlockTypeRegistry<?>> getRegistryStreamCodec() {
        return BlockSetInternal.getRegistriesStreamCodec();
    }

    protected BlockTypeRegistry(Class<T> typeClass, String name) {
        this.typeClass = typeClass;
        this.name = name;
        this.valuesReg = new MapRegistry(name);
        this.streamCodecSlow = class_9135.method_56368(this.getCodec());
    }

    @NotNull
    public Iterator<T> iterator() {
        return this.valuesReg.iterator();
    }

    public int method_10204() {
        return this.valuesReg.method_10204();
    }

    @Nullable
    public T byId(int id) {
        return (T)((BlockType)this.valuesReg.method_10200(id));
    }

    public int getId(T value) {
        return this.valuesReg.method_10206(value);
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public Class<T> getType() {
        return this.typeClass;
    }

    @Deprecated(forRemoval=true)
    public T getFromNBT(String name) {
        return (T)((BlockType)this.valuesReg.getValueOrDefault(class_2960.method_60654((String)name), this.getDefaultType()));
    }

    @Nullable
    public T get(class_2960 res) {
        if (!(this.frozen || this.isBeingFrozenHack && !PlatHelper.isDev())) {
            throw new AssertionError((Object)"Tried to get an object from block set registry before the registry was finalized.");
        }
        return (T)((BlockType)this.valuesReg.getValue(res));
    }

    public class_2960 getKey(T input) {
        return this.valuesReg.getKey(input);
    }

    public Codec<T> getCodec() {
        return this.valuesReg;
    }

    @Deprecated(forRemoval=true)
    public class_9139<ByteBuf, T> getStreamCodec() {
        return this.streamCodecSlow;
    }

    public class_9139<ByteBuf, T> getStreamCodecExplicit() {
        return this.streamCodecSlow;
    }

    public abstract T getDefaultType();

    public Collection<T> getValues() {
        return this.valuesReg.getValues();
    }

    public String typeName() {
        return this.name;
    }

    protected abstract Optional<T> detectTypeFromBlock(class_2248 var1, class_2960 var2);

    protected T register(T newType) {
        if (this.frozen) {
            throw new UnsupportedOperationException("Tried to register a block types after registry events");
        }
        if (!this.valuesReg.containsKey(((BlockType)newType).id)) {
            this.valuesReg.register(((BlockType)newType).id, newType);
        }
        return newType;
    }

    @Deprecated(forRemoval=true)
    public Collection<BlockType.SetFinder<T>> getFinders() {
        return List.of();
    }

    public synchronized void addFinder(BlockType.SetFinder<T> finder) {
        if (this.frozen) {
            throw new UnsupportedOperationException("Tried to register a block type finder after registry events");
        }
        this.finders.add(finder);
    }

    public synchronized void addRemover(class_2960 id) {
        if (this.frozen) {
            throw new UnsupportedOperationException("Tried remove a block type after registry events");
        }
        this.notInclude.add(id);
    }

    @ApiStatus.Internal
    public void finalizeAndFreeze() {
        if (this.frozen) {
            throw new UnsupportedOperationException("Block types are already finalized");
        }
        this.frozen = true;
        this.getValues().forEach(BlockType::initializeChildrenBlocks);
        this.getValues().forEach(BlockType::initializeChildrenItems);
    }

    @ApiStatus.Internal
    public void buildAll() {
        if (!this.frozen) {
            this.isBeingFrozenHack = true;
            T defaultType = this.getDefaultType();
            if (defaultType != null) {
                this.register(defaultType);
            }
            this.finders.stream().map(BlockType.SetFinder::get).forEach(f -> f.ifPresent(this::register));
            for (class_2248 b : class_7923.field_41175) {
                if (CompatHandler.POLYMER && PolymerCompat.isPolymerObj(b)) continue;
                this.detectTypeFromBlock(b, Utils.getID(b)).ifPresent(t -> {
                    if (!this.notInclude.contains(t.getId())) {
                        this.register(t);
                    }
                });
            }
            this.isBeingFrozenHack = false;
            this.finders.clear();
            this.notInclude.clear();
        }
    }

    @ApiStatus.Internal
    public void addTypeTranslations(AfterLanguageLoadEvent language) {
        this.getValues().forEach(blockType -> {
            if (language.isDefault()) {
                language.addEntry(blockType.getTranslationKey(), blockType.getReadableName());
            }
        });
    }

    @Nullable
    public T getBlockTypeOf(class_1935 itemLike) {
        class_1747 bi;
        BlockType ofBlock;
        BlockType blockType = (BlockType)this.childrenToType.get((Object)itemLike);
        if (blockType != null) {
            return (T)blockType;
        }
        if (itemLike == class_1802.field_8162 || itemLike == class_2246.field_10124) {
            return null;
        }
        if (itemLike instanceof class_1747 && (ofBlock = (BlockType)this.childrenToType.get((Object)(bi = (class_1747)itemLike).method_7711())) != null) {
            return (T)ofBlock;
        }
        if (itemLike instanceof class_2248) {
            class_2248 block = (class_2248)itemLike;
            class_1792 item = block.method_8389();
            if (item == class_1802.field_8162) {
                throw new IllegalStateException("Block " + String.valueOf(block) + " has no item. This likely means getBlockTypeOf was called too early. This is a bug");
            }
            return (T)((BlockType)this.childrenToType.get((Object)item));
        }
        return null;
    }

    protected void mapObjectToType(Object itemLike, BlockType type) {
        class_1747 bi;
        this.childrenToType.put(itemLike, (Object)type);
        if (itemLike instanceof class_1747 && !this.childrenToType.containsKey((Object)(bi = (class_1747)itemLike).method_7711())) {
            this.childrenToType.put((Object)bi.method_7711(), (Object)type);
        }
    }

    public int priority() {
        return 100;
    }

    public INamedSupplier<T> makeFutureHolder(class_2960 id) {
        return INamedSupplier.memoize(id, () -> this.get(id));
    }
}

