/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.misc;

import java.util.AbstractList;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class RollingBuffer<T>
extends AbstractList<T>
implements RandomAccess {
    private final Object[] buffer;
    private int start = 0;
    private int size = 0;

    public RollingBuffer(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("Capacity must be > 0");
        }
        this.buffer = new Object[capacity];
    }

    private int cap() {
        return this.buffer.length;
    }

    private int toPhysical(int logicalIndex) {
        return (this.start + logicalIndex) % this.cap();
    }

    private T elementAtPhysical(int physical) {
        return (T)this.buffer[physical];
    }

    private void setPhysical(int physical, T e) {
        this.buffer[physical] = e;
    }

    public void push(T element) {
        this.addLast(element);
    }

    public int capacity() {
        return this.cap();
    }

    public boolean isFull() {
        return this.size == this.cap();
    }

    public void fillAll(T element) {
        for (int i = 0; i < this.cap(); ++i) {
            this.addLast(element);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public T get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", size: " + this.size);
        }
        return this.elementAtPhysical(this.toPhysical(index));
    }

    @Override
    public T set(int index, T element) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", size: " + this.size);
        }
        int p = this.toPhysical(index);
        Object old = this.buffer[p];
        this.buffer[p] = element;
        return (T)old;
    }

    @Override
    public boolean add(T element) {
        this.addLast(element);
        return true;
    }

    @Override
    public void add(int index, T element) {
        if (index == 0) {
            this.addFirst(element);
        } else if (index == this.size) {
            this.addLast(element);
        } else {
            throw new UnsupportedOperationException("Middle insert not supported in RollingBuffer");
        }
    }

    @Override
    public T remove(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", size: " + this.size);
        }
        ++this.modCount;
        int removePhys = this.toPhysical(index);
        Object removed = this.buffer[removePhys];
        if (index < this.size / 2) {
            for (int i = index; i > 0; --i) {
                int from = this.toPhysical(i - 1);
                int to = this.toPhysical(i);
                this.buffer[to] = this.buffer[from];
            }
            this.buffer[this.start] = null;
            this.start = (this.start + 1) % this.cap();
        } else {
            for (int i = index; i < this.size - 1; ++i) {
                int from = this.toPhysical(i + 1);
                int to = this.toPhysical(i);
                this.buffer[to] = this.buffer[from];
            }
            int tailPhys = this.toPhysical(this.size - 1);
            this.buffer[tailPhys] = null;
        }
        --this.size;
        return (T)removed;
    }

    @Override
    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.buffer[this.toPhysical((int)i)] = null;
        }
        this.start = 0;
        this.size = 0;
    }

    @Override
    public void addFirst(T e) {
        ++this.modCount;
        if (this.size < this.cap()) {
            this.start = (this.start - 1 + this.cap()) % this.cap();
            this.setPhysical(this.start, e);
            ++this.size;
        } else {
            this.start = (this.start - 1 + this.cap()) % this.cap();
            this.setPhysical(this.start, e);
        }
    }

    @Override
    public void addLast(T e) {
        ++this.modCount;
        if (this.size < this.cap()) {
            int tailPhys = this.toPhysical(this.size);
            this.setPhysical(tailPhys, e);
            ++this.size;
        } else {
            this.setPhysical(this.start, e);
            this.start = (this.start + 1) % this.cap();
        }
    }

    @Override
    public T getFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.elementAtPhysical(this.start);
    }

    @Override
    public T getLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int tailPhys = this.toPhysical(this.size - 1);
        return this.elementAtPhysical(tailPhys);
    }

    @Override
    public T removeFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        ++this.modCount;
        Object v = this.buffer[this.start];
        this.buffer[this.start] = null;
        this.start = (this.start + 1) % this.cap();
        --this.size;
        return (T)v;
    }

    @Override
    public T removeLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        ++this.modCount;
        int tailPhys = this.toPhysical(this.size - 1);
        Object v = this.buffer[tailPhys];
        this.buffer[tailPhys] = null;
        --this.size;
        return (T)v;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("RollingBuffer{");
        for (int i = 0; i < this.size; ++i) {
            sb.append(this.get(i));
            if (i >= this.size - 1) continue;
            sb.append(", ");
        }
        sb.append('}');
        return sb.toString();
    }
}

