/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.misc.neoforge;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.mehvahdjukaar.moonlight.neoforge.MoonlightForge;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ModLootModifiers {
    public static final DeferredRegister<MapCodec<? extends IGlobalLootModifier>> LOOT_MODIFIERS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"moonlight");
    public static final DeferredHolder<?, ?> ADD_ITEM_GLM = LOOT_MODIFIERS.register("add_item", () -> AddItemModifier.CODEC);
    public static final DeferredHolder<?, ?> REPLACE_ITEM_GLM = LOOT_MODIFIERS.register("replace_item", () -> ReplaceItemModifier.CODEC);

    public static void register() {
        LOOT_MODIFIERS.register(MoonlightForge.getCurrentBus());
    }

    public static class ReplaceItemModifier
    extends LootModifier {
        public static final MapCodec<ReplaceItemModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> ReplaceItemModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ItemStack.CODEC.fieldOf("item").forGetter(m -> m.itemStack)).apply((Applicative)inst, ReplaceItemModifier::new));
        private final ItemStack itemStack;

        protected ReplaceItemModifier(LootItemCondition[] conditionsIn, ItemStack addedItemStack) {
            super(conditionsIn);
            this.itemStack = addedItemStack;
        }

        @NotNull
        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            if (!generatedLoot.isEmpty()) {
                generatedLoot.set(0, (Object)this.itemStack.copy());
            }
            return generatedLoot;
        }

        public MapCodec<? extends IGlobalLootModifier> codec() {
            return CODEC;
        }
    }

    public static class AddItemModifier
    extends LootModifier {
        public static final MapCodec<AddItemModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> AddItemModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ItemStack.CODEC.fieldOf("item").forGetter(m -> m.addedItemStack)).apply((Applicative)inst, AddItemModifier::new));
        private final ItemStack addedItemStack;

        public AddItemModifier(LootItemCondition[] conditionsIn, ItemStack addedItemStack) {
            super(conditionsIn);
            this.addedItemStack = addedItemStack;
        }

        @NotNull
        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            ItemStack addedStack = this.addedItemStack.copy();
            if (addedStack.getCount() < addedStack.getMaxStackSize()) {
                generatedLoot.add((Object)addedStack);
            } else {
                ItemStack subStack;
                for (int i = addedStack.getCount(); i > 0; i -= subStack.getCount()) {
                    subStack = addedStack.copy();
                    subStack.setCount(Math.min(addedStack.getMaxStackSize(), i));
                    generatedLoot.add((Object)subStack);
                }
            }
            return generatedLoot;
        }

        public MapCodec<? extends IGlobalLootModifier> codec() {
            return CODEC;
        }
    }
}

