package net.mehvahdjukaar.moonlight.api.fluids;

import com.google.common.base.Suppliers;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.mehvahdjukaar.moonlight.api.misc.StrOpt;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.Map.Entry;
import java.util.function.Supplier;


public class FluidContainerList implements Iterable<FluidContainerList.Category> {

    /*
    public static final Codec<FluidContainerList> CODEC = RecordCodecBuilder.merge((instance) -> instance.group(
            Category.CODEC.listOf().fieldOf("containers").forGetter(FluidContainerList::encodeList)
    ).apply(instance, FluidContainerList::new));
    */
    private final Map<class_1792, Category> emptyToFilledMap = new IdentityHashMap<>();

    public FluidContainerList(List<Category> categoryList) {
        categoryList.forEach(this::addCategory);
    }

    public FluidContainerList() {
    }

    private void addCategory(Category newCategory) {
        if (!newCategory.isEmpty()) {
            if (emptyToFilledMap.containsKey(newCategory.emptyContainer)) {
                Category c = emptyToFilledMap.get(newCategory.emptyContainer);
                if (c.containerCapacity == newCategory.containerCapacity) {
                    c.filled.addAll(newCategory.filled);
                }
            } else {
                emptyToFilledMap.put(newCategory.emptyContainer, newCategory);
            }
        }
    }

    public Optional<class_1792> getEmpty(class_1792 filledContainer) {
        for (var e : this.emptyToFilledMap.entrySet()) {
            if (e.getValue().getFilledItems().contains(filledContainer)) return Optional.of(e.getKey());
        }
        return Optional.empty();
    }

    public Optional<class_1792> getFilled(class_1792 emptyContainer) {
        Category c = this.emptyToFilledMap.get(emptyContainer);
        if (c != null) return c.getFirstFilled();
        return Optional.empty();
    }

    public Optional<Category> getCategoryFromEmpty(class_1792 emptyContainer) {
        return Optional.ofNullable(this.emptyToFilledMap.get(emptyContainer));
    }

    public Optional<Category> getCategoryFromFilled(class_1792 filledContainer) {
        return this.getEmpty(filledContainer).map(this.emptyToFilledMap::get);
    }


    protected Optional<List<Category>> encodeList() {
        return emptyToFilledMap.isEmpty() ? Optional.empty() : Optional.of(new ArrayList<>(emptyToFilledMap.values()));
    }

    public Collection<class_1792> getPossibleFilled() {
        List<class_1792> list = new ArrayList<>();
        this.emptyToFilledMap.values().forEach(c -> list.addAll(c.filled));
        return list;
    }

    public Collection<class_1792> getPossibleEmpty() {
        return this.emptyToFilledMap.keySet();
    }

    public Collection<Category> getCategories() {
        return this.emptyToFilledMap.values();
    }


    @Override
    public @NotNull Iterator<Category> iterator() {
        return this.emptyToFilledMap.values().iterator();
    }

    protected void merge(FluidContainerList other) {
        other.emptyToFilledMap.values().forEach(this::addCategory);
    }

    protected void add(class_1792 empty, class_1792 filled, int amount) {
        var c = this.emptyToFilledMap.computeIfAbsent(empty, i -> new Category(i, amount));
        c.addItem(filled);
    }

    protected void add(class_1792 empty, class_1792 filled, int amount, class_3414 fillSound, class_3414 emptySound) {
        var c = this.emptyToFilledMap.computeIfAbsent(empty, i -> new Category(i, amount));
        c.addItem(filled);
        if (c.fillSound == null) c.fillSound = fillSound;
        if (c.emptySound == null) c.emptySound = emptySound;
    }


    public static class Category {

        private static final Supplier<Category> EMPTY = Suppliers.memoize(() ->
                new Category(class_7923.field_41178.method_10223(class_7923.field_41178.method_10137()), 1));

        public static final Codec<Category> CODEC = RecordCodecBuilder.create((instance) -> instance.group(
                class_2960.field_25139.fieldOf("empty").forGetter(c -> Utils.getID(c.emptyContainer)),
                SoftFluid.Capacity.INT_CODEC.fieldOf("capacity").forGetter(Category::getCapacity),
                class_2960.field_25139.listOf().fieldOf("filled").forGetter(c -> c.filled.stream().map(Utils::getID).toList()),
                StrOpt.of(class_7923.field_41172.method_39673(), "fill_sound")
                        .forGetter(c -> Optional.ofNullable(c.getFillSound())),
                StrOpt.of(class_7923.field_41172.method_39673(), "empty_sound")
                        .forGetter(c -> Optional.ofNullable(c.getEmptySound()))
        ).apply(instance, Category::decode));

        private final class_1792 emptyContainer;
        private final int containerCapacity;
        private class_3414 fillSound;
        private class_3414 emptySound;
        private final List<class_1792> filled = new ArrayList<>();


        private Category(class_1792 emptyContainer, int capacity, @Nullable class_3414 fillSound, @Nullable class_3414 emptySound) {
            this.emptyContainer = emptyContainer;
            this.containerCapacity = capacity;
            this.fillSound = fillSound;
            this.emptySound = emptySound;
        }

        private Category(class_1792 emptyContainer, int capacity) {
            this(emptyContainer, capacity, null, null);
        }

        private static Category decode(class_2960 empty, int capacity, List<class_2960> filled) {
            return decode(empty, capacity, filled, Optional.empty(), Optional.empty());
        }

        private static Category decode(class_2960 empty, int capacity, List<class_2960> filled,
                                       Optional<class_3414> fillSound, Optional<class_3414> emptySound) {
            var opt = class_7923.field_41178.method_17966(empty);
            if (opt.isEmpty()) return EMPTY.get();
            var category = new Category(opt.get(), capacity, fillSound.orElse(null), emptySound.orElse(null));

            filled.forEach(f -> {
                var opt2 = class_7923.field_41178.method_17966(f);
                opt2.ifPresent(category::addItem);
            });
            if (category.isEmpty()) return EMPTY.get();
            return category;
        }

        public class_1792 getEmptyContainer() {
            return emptyContainer;
        }


        /**
         * @return amount of liquid contained in this item in bottles
         */
        public int getCapacity() {
            return containerCapacity;
        }

        @Deprecated(forRemoval = true)
        public int getAmount() {
            return containerCapacity;
        }

        private void addItem(class_1792 i) {
            if (!i.method_7854().method_7960() && !filled.contains(i)) filled.add(i);
        }

        public class_3414 getFillSound() {
            return fillSound == null ? class_3417.field_14779 : fillSound;
        }

        public class_3414 getEmptySound() {
            return emptySound == null ? class_3417.field_14826 : emptySound;
        }

        public List<class_1792> getFilledItems() {
            return filled;
        }

        public boolean isEmpty() {
            return this.filled.isEmpty();
        }

        public Optional<class_1792> getFirstFilled() {
            return this.filled.stream().findFirst();
        }
    }
}
