package net.mehvahdjukaar.moonlight.api.fluids;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.mehvahdjukaar.moonlight.api.client.TextureCache;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.RenderedTexturesManager;
import net.mehvahdjukaar.moonlight.api.misc.RegistryAccessJsonReloadListener;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5253;
import net.minecraft.class_5455;
import net.minecraft.class_7764;
import java.util.Map;
import java.util.Map.Entry;

// client class
public class SoftFluidColors extends RegistryAccessJsonReloadListener {

    public SoftFluidColors() {
        super(new Gson(), "moonlight/dummy");
    }

    @Override
    public void parse(Map<class_2960, JsonElement> jsonMap, class_5455 access) {
        RenderedTexturesManager.clearCache();
        TextureCache.clear();
        refreshParticleColors(access);
    }

    //why is it called twice?
    //once on fluid map reload (server join on client) since there we have all the fluids
    //then once when resources are reloaded (resource pack change) since these depend on textures
    public static void refreshParticleColors(class_5455 access) {
        class_310 mc = class_310.method_1551();

        class_2378<SoftFluid> reg = access.method_33310(SoftFluidRegistry.KEY).orElse(null);
        //dumb velocity
        if (reg == null) {
            for (SoftFluid f : SoftFluidRegistry.getValues()) {
                //purple, clearly something is wrong
                f.averageTextureTint = 0xff_aa00ff;
            }
            Moonlight.warnInvalidServer();
            return;
        }

        for (var entry : reg.method_29722()) {
            SoftFluid fluid = entry.getValue();
            class_2960 location = fluid.getStillTexture();
            int averageColor = -1;
            int tint = fluid.getTintMethod().appliesToStill() ? fluid.getTintColor() : -1;

            class_1059 textureMap = mc.method_1554().method_24153(class_1059.field_5275);
            class_1058 sprite = textureMap.method_4608(location);
            try {
                averageColor = getAverageColor(sprite, tint);
            } catch (Exception e) {
                Moonlight.LOGGER.warn("Failed to load particle color for {} using current resource pack. might be a broken png.mcmeta", sprite);
            }
            fluid.averageTextureTint = averageColor;
        }
    }

    //credits to Random832
    @SuppressWarnings("ConstantConditions")
    private static int getAverageColor(class_1058 sprite, int tint) {
        class_7764 c = sprite.method_45851();
        if (sprite == null || c.method_45819() == 0) return -1;

        int tintR = tint >> 16 & 255;
        int tintG = tint >> 8 & 255;
        int tintB = tint & 255;
        int total = 0, totalR = 0, totalB = 0, totalG = 0;

        for (int tryFrame = 0; tryFrame < c.method_45819(); tryFrame++) {
            try {
                for (int x = 0; x < c.method_45807(); x++) {
                    for (int y = 0; y < c.method_45815(); y++) {

                        int pixel = ClientHelper.getPixelRGBA(sprite, tryFrame, x, y);

                        int pixelB = pixel >> 16 & 255;
                        int pixelG = pixel >> 8 & 255;
                        int pixelR = pixel & 255;
                        ++total;
                        totalR += pixelR;
                        totalG += pixelG;
                        totalB += pixelB;
                    }
                }
                break;
            } catch (Exception e) {
                total = 0;
                totalR = 0;
                totalB = 0;
                totalG = 0;
            }
        }
        if (total <= 0) return -1;
        return class_5253.class_5254.method_27764(255,
                totalR / total * tintR / 255,
                totalG / total * tintG / 255,
                totalB / total * tintB / 255);
    }

    @ExpectPlatform
    public static int getSpecialColor(SoftFluidStack softFluidStack, class_1920 world, class_2338 pos) {
        throw new AssertionError();
    }
}