package net.mehvahdjukaar.moonlight.api.fluids;

import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.mixins.MapItemDataPacketMixin;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class SoftFluidRegistry {

    public static final class_5321<class_2378<SoftFluid>> KEY = class_5321.method_29180(Moonlight.res("soft_fluids"));

    public static class_6880<SoftFluid> getEmpty() {
        return BuiltInSoftFluids.EMPTY.getHolder();
    }

    public static SoftFluid empty() {
        return BuiltInSoftFluids.EMPTY.get();
    }

    public static class_2378<SoftFluid> hackyGetRegistry() {
        return Utils.hackyGetRegistry(KEY);
    }

    public static class_2378<SoftFluid> getRegistry(class_5455 registryAccess) {
        return registryAccess.method_33310(KEY).orElseThrow();
    }

    public static Collection<SoftFluid> getValues() {
        return hackyGetRegistry().method_10220().toList();
    }

    public static Collection<class_6880.class_6883<SoftFluid>> getHolders() {
        return hackyGetRegistry().method_40270().toList();
    }

    public static Set<Map.Entry<class_5321<SoftFluid>, SoftFluid>> getEntries() {
        return hackyGetRegistry().method_29722();
    }

    public static class_6880<SoftFluid> getHolder(class_2960 id) {
        var opt = getOptionalHolder(id);
        if (opt.isPresent()) return opt.get();
        return getEmpty();
    }

    public static Optional<class_6880.class_6883<SoftFluid>> getOptionalHolder(class_2960 id) {
        id = backwardsCompat(id);
        return hackyGetRegistry().method_40264(class_5321.method_29179(KEY, id));
    }

    @NotNull
    private static class_2960 backwardsCompat(class_2960 id) {
        String namespace = id.method_12836();
        if (namespace.equals("selene") || namespace.equals("minecraft"))
            id = Moonlight.res(id.method_12832()); //backwards compat
        return id;
    }
}