package net.mehvahdjukaar.moonlight.api.fluids.fabric;

import ;
import java.util.Optional;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.misc.Triplet;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_7923;

public class SoftFluidImpl {

    public static void addFluidSpecificAttributes(SoftFluid.Builder builder, class_3611 fluid) {
        FluidVariant variant = FluidVariant.of(fluid);
        builder.luminosity(FluidVariantAttributes.getLuminance(variant));
        class_2561 tr = FluidVariantAttributes.getName(variant);
        if (tr != null) builder.translation(tr);
    }

    public static Triplet<class_2960, class_2960, Integer> getRenderingData(class_2960 useTexturesFrom) {
        var fluid = class_7923.field_41173.method_17966(useTexturesFrom);
        if (fluid.isPresent()) {
            var f = fluid.get();
            var prop = FluidRenderHandlerRegistry.INSTANCE.get(f);
            if (prop != null) {
                try {
                    var textures = prop.getFluidSprites(null, null, f.method_15785());
                    int tint = prop.getFluidColor(null, null, f.method_15785());
                    return Triplet.of(textures[0].method_45851().method_45816(), textures[1].method_45851().method_45816(), tint);
                } catch (Exception e) {
                    throw new IllegalStateException("Fluid " + useTexturesFrom + " had invalid rendering data ", e);
                }
            }
        }
        return null;
    }
}
