package net.mehvahdjukaar.moonlight.api.fluids.fabric;

import net.fabricmc.fabric.api.transfer.v1.fluid.FluidConstants;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.util.PotionNBTHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3611;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class SoftFluidStackImpl extends SoftFluidStack{

    public SoftFluidStackImpl(class_6880<SoftFluid> fluid, int count, class_2487 tag) {
        super(fluid, count, tag);
    }

    public static SoftFluidStack of(class_6880<SoftFluid> fluid, int count, @Nullable class_2487 tag) {
        return new SoftFluidStackImpl(fluid, count, tag);
    }

    public static FluidVariant toFabricFluid(SoftFluidStack softFluid) {
        // tag stuff
        List<String> nbtKey = softFluid.fluid().getNbtKeyFromItem();
        class_2487 tag = softFluid.getTag();
        class_2487 newCom = new class_2487();
        if (tag != null && !tag.method_33133()  && nbtKey != null) {
            for (String k : nbtKey) {

                class_2520 c = tag.method_10580(k);
                if (c != null) {
                    newCom.method_10566(k, c);
                }
            }
            if (newCom.method_33133()) newCom = null;
        }
        class_3611 vanillaFluid = softFluid.fluid().getVanillaFluid();
        return FluidVariant.of(vanillaFluid, newCom);
    }

    public static SoftFluidStack fromFabricFluid(FluidVariant fluidStack, int bottlesAmount) {
        return SoftFluidStack.fromFluid(fluidStack.getFluid(), bottlesAmount,
                fluidStack.hasNbt() ? fluidStack.getNbt().method_10553() : null);
    }

}
