package net.mehvahdjukaar.moonlight.api.item;

import com.google.common.base.Suppliers;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.minecraft.class_2248;
import java.util.function.Supplier;

public class BlockTypeBasedBlockItem<T extends BlockType> extends FuelBlockItem {

    private final T blockType;

    public BlockTypeBasedBlockItem(class_2248 pBlock, class_1793 pProperties, T blockType, Supplier<Integer> burnTime) {
        super(pBlock, pProperties, burnTime);
        this.blockType = blockType;
    }

    public BlockTypeBasedBlockItem(class_2248 pBlock, class_1793 pProperties, T blockType) {
        this(pBlock, pProperties, blockType, Suppliers.memoize(() -> PlatHelper.getBurnTime(blockType.mainChild().method_8389().method_7854())));
    }

    public T getBlockType() {
        return blockType;
    }
}
