package net.mehvahdjukaar.moonlight.api.item;

import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.misc.IExtendedItem;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_742;
import net.minecraft.class_759;

/**
 * Injected early, allows canceling most of vanilla code.
 * Use if you want to render the arm with item or similar (like vanilla maps)
 */
public interface IFirstPersonSpecialItemRenderer {

    /**
     * Implement if you want to also override the item renderer code
     *
     * @return true to cancel original item renderer
     */
    boolean renderFirstPersonItem(final class_742 player, final class_1799 stack,  final class_1268 hand, final class_1306 arm, final class_4587 poseStack,
                                  float partialTicks, float pitch, float attackAnim, float equipAnim,
                                  class_4597 buffer, int light, class_759 renderer);
//TODO: replace all interaction hands with HumanoidHand!!
    /**
     * Alternatively, if you don't own the item and cant implement this interface in it you can use this call to attach your interface to an item
     * Note that when using other any of these 3 extensions only 1 object can be attached to any item, so be sure what you attach implements all of them
     */
    static void attachToItem(class_1792 target, IFirstPersonSpecialItemRenderer object) {
        if (PlatHelper.getPhysicalSide().isClient()) {
            IExtendedItem extendedItem = (IExtendedItem) target;
            if (extendedItem.moonlight$getClientAnimationExtension() != null) {
                if (PlatHelper.isDev())
                    throw new AssertionError("A client animation extension was already registered for this item");
            }
            extendedItem.moonlight$setClientAnimationExtension(object);
        }
    }

    static IFirstPersonSpecialItemRenderer get(class_1792 target) {
        if (target instanceof IFirstPersonSpecialItemRenderer p) return p;
        if (((IExtendedItem) target).moonlight$getClientAnimationExtension() instanceof IFirstPersonSpecialItemRenderer p)
            return p;
        return null;
    }
}
