package net.mehvahdjukaar.moonlight.api.map;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_22;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;


public interface CustomMapData<H extends CustomMapData.DirtyCounter> {


    record Type<T extends CustomMapData<?>>(class_2960 id, Supplier<T> factory) {

        @SuppressWarnings("unchecked")
        @NotNull
        public T get(class_22 mapData) {
            return (T) ((ExpandedMapData) mapData).getCustomData().get(this.id);
        }

    }

    Type<?> getType();

    default boolean persistOnCopyOrLock(){
        return true;
    }

    default boolean persistOnRescale(){
        return true;
    }

    default boolean onItemUpdate(class_22 data, class_1297 entity) {
        return false;
    }

    @Nullable
    default class_2561 onItemTooltip(class_22 data, class_1799 stack) {
        return null;
    }

    H createDirtyCounter();

    void load(class_2487 tag);

    void loadUpdateTag(class_2487 tag);

    void save(class_2487 tag);

    void saveToUpdateTag(class_2487 tag, H dirtyCounter);

    default void setDirty(class_22 data, Consumer<H> dirtySetter) {
        Type<?> type = this.getType();
        ((ExpandedMapData) data).setCustomDataDirty(type, dirtySetter);
    }

    class SimpleDirtyCounter implements DirtyCounter {
        private boolean dirty = true;

        public void markDirty() {
            this.dirty = true;
        }

        public boolean isDirty() {
            return dirty;
        }

        @Override
        public void clearDirty() {
            dirty = false;
        }
    }

    interface DirtyCounter {

        boolean isDirty();

        void clearDirty();
    }
}

