package net.mehvahdjukaar.moonlight.api.map;

import net.mehvahdjukaar.moonlight.api.integration.MapAtlasCompat;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1937;
import net.minecraft.class_20;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import java.util.Locale;

import static net.mehvahdjukaar.moonlight.core.CompatHandler.MAP_ATLASES;

public class MapHelper {

    @Nullable
    public static class_22 getMapData(class_1799 stack, class_1937 level, @Nullable class_1657 player) {
        class_22 data;
        data = class_1806.method_8001(stack, level);
        if (data == null && MAP_ATLASES && player != null)
            data = MapAtlasCompat.getSavedDataFromAtlas(stack, level, player);
        return data;
    }

    @Deprecated(forRemoval = true)
    public static Integer getMapId(class_1799 stack, class_1657 player, Object data) {
        Integer i = class_1806.method_8003(stack);
        if (i == null && MAP_ATLASES) i = MapAtlasCompat.getMapIdFromAtlas(stack, player.method_37908(), data);
        return i;
    }

    /**
     * adds a vanilla decoration
     *
     * @param stack    map item stack
     * @param pos      decoration world pos
     * @param type     vanilla decorationType
     * @param mapColor map item tint color
     */
    public static void addVanillaDecorations(class_1799 stack, class_2338 pos, class_20.class_21 type, int mapColor) {
        class_22.method_110(stack, pos, "+", type);
        if (mapColor != 0) {
            class_2487 com = stack.method_7911("display");
            com.method_10569("MapColor", mapColor);
        }
    }

    //TODO: rename

    /**
     * Adds a static decoration tp a map itemstack NBT.<br>
     * Such decoration will not have any world marker associated and wont be toggleable
     *
     * @param stack    map item stack
     * @param pos      decoration world pos
     * @param type     custom decorationType
     * @param mapColor map item tint color
     */
    public static void addDecorationToMap(class_1799 stack, class_2338 pos, MapDecorationType<?, ?> type, int mapColor) {

        class_2499 tags;
        if (stack.method_7985() && stack.method_7969().method_10573("CustomDecorations", 9)) {
            tags = stack.method_7969().method_10554("CustomDecorations", 10);
        } else {
            tags = new class_2499();
            stack.method_7959("CustomDecorations", tags);
        }
        class_2487 tag = new class_2487();
        tag.method_10582("type", Utils.getID(type).toString());
        tag.method_10569("x", pos.method_10263());
        tag.method_10569("z", pos.method_10260());
        tags.add(tag);
        if (mapColor != 0) {
            class_2487 com = stack.method_7911("display");
            com.method_10569("MapColor", mapColor);
        }
    }

    /**
     * see addDecorationToMap
     * This is useful when you don't have a reference to a map decoration object as it couldbe one that has been added with datapack
     *
     * @param id decoration type id. if invalid will default to generic structure decoration
     */
    public static void addDecorationToMap(class_1799 stack, class_2338 pos, class_2960 id, int mapColor) {
        if (id.method_12836().equals("minecraft")) {
            class_20.class_21 type = getVanillaType(id);
            if (type != null) {
                addVanillaDecorations(stack, pos, type, mapColor);
                return;
            }
        }
        MapDecorationType<?, ?> type = MapDataRegistry.get(id);
        if (type != null) {
            addDecorationToMap(stack, pos, type, mapColor);
        } else {
            addVanillaDecorations(stack, pos, class_20.class_21.field_84, mapColor);
        }
    }

    @Nullable
    private static class_20.class_21 getVanillaType(class_2960 id) {
        return Arrays.stream(class_20.class_21.values()).filter(t -> t.toString()
                        .toLowerCase(Locale.ROOT).equals(id.method_12832())).findFirst()
                .orElse(null);
    }

    /**
     * Adds all the map markers that can originate from the block at a given position
     */
    public static boolean toggleMarkersAtPos(class_1937 level, class_2338 pos, class_1799 stack, @Nullable class_1657 player) {
        class_22 data = getMapData(stack, level, player);
        if (data instanceof ExpandedMapData expandedMapData) {
            return expandedMapData.toggleCustomDecoration(level, pos);
        }
        return false;
    }

    public static boolean removeAllCustomMarkers(class_1937 level, class_1799 stack, @Nullable class_1657 player) {
        class_22 data = getMapData(stack, level, player);
        if (data instanceof ExpandedMapData expandedMapData) {
            if (!level.field_9236) {
                expandedMapData.resetCustomDecoration();
                return true;
            }
        }
        return false;
    }

    /**
     * Helper that map decoration directly to map data using a persistent map marker. Only supports moonlight markers
     */
    public static boolean addSimpleDecorationToMap(class_22 data, class_1937 level, class_2960 id,
                                                   class_2338 pos, @Nullable class_2561 name) {
        MapDecorationType<?, ?> type = MapDataRegistry.get(id);
        if (type != null) {
            var marker = type.createEmptyMarker();
            marker.setPersistent(true);
            marker.setPos(pos);
            marker.setName(name);
            ((ExpandedMapData) data).addCustomMarker(marker);
            return true;
        }
        return false;
    }

}
