package net.mehvahdjukaar.moonlight.api.map.client;

import com.google.common.collect.Maps;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_22;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4075;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.jetbrains.annotations.Nullable;

import java.util.Map;
import java.util.function.Function;

public class MapDecorationClientManager extends class_4075 {

    public static final class_2960 LOCATION_MAP_MARKERS = Moonlight.res("textures/atlas/map_markers.png");
    public static final class_1921 MAP_MARKERS_RENDER_TYPE = class_1921.method_23028(LOCATION_MAP_MARKERS);
    private static MapDecorationClientManager instance;

    public MapDecorationClientManager() {
        super(class_310.method_1551().method_1531(), LOCATION_MAP_MARKERS, Moonlight.res("map_markers"));
        instance = this;
    }

    public static class_1058 getAtlasSprite(class_2960 location) {
        return instance.method_18667(location);
    }


    @Deprecated(forRemoval = true)
    public static <T extends CustomMapDecoration> void registerCustomRenderer(MapDecorationType<T, ?> type, DecorationRenderer<T> renderer) {
        registerCustomRenderer(type.getCustomFactoryID(), r -> renderer);
    }

    /**
     * Registers a renderer for this decoration. Use it to add fancy ones
     */
    public static <T extends CustomMapDecoration> void registerCustomRenderer(class_2960 typeFactoryId, Function<class_2960, DecorationRenderer<T>> renderer) {
        CUSTOM_RENDERERS_FACTORIES.put(typeFactoryId, (Function<class_2960, DecorationRenderer<?>>) (Object) renderer);
    }

    private static final Map<class_2960, Function<class_2960, DecorationRenderer<?>>> CUSTOM_RENDERERS_FACTORIES = Maps.newHashMap();

    private static final Map<MapDecorationType<?, ?>, DecorationRenderer<?>> RENDERERS = Maps.newHashMap();


    private static <T extends CustomMapDecoration> DecorationRenderer<T> createRenderer(MapDecorationType<T, ?> type) {
        var id = Utils.getID(type);
        class_2960 texture = new class_2960(id.method_12836(), "map_marker/" + id.method_12832());
        var custom = CUSTOM_RENDERERS_FACTORIES.get(type.getCustomFactoryID());
        if (custom != null) return (DecorationRenderer<T>) custom.apply(texture);
        else return new DecorationRenderer<>(texture);
    }

    public static <E extends CustomMapDecoration> DecorationRenderer<E> getRenderer(E decoration) {
        return (DecorationRenderer<E>) getRenderer(decoration.getType());
    }

    public static <E extends CustomMapDecoration, T extends MapDecorationType<E, ?>> DecorationRenderer<E> getRenderer(T type) {
        return (DecorationRenderer<E>) RENDERERS.computeIfAbsent(type, t -> createRenderer(type));
    }

    public static <T extends CustomMapDecoration> boolean render(T decoration, class_4587 matrixStack,
                                                                 class_4588 vertexBuilder,
                                                                 class_4597 buffer,
                                                                 @Nullable class_22 mapData,
                                                                 boolean isOnFrame, int light, int index) {
        DecorationRenderer<T> renderer = getRenderer(decoration);
        if (renderer != null) {
            return renderer.render(decoration, matrixStack, vertexBuilder, buffer, mapData, isOnFrame, light, index);
        }
        return false;
    }


}
