package net.mehvahdjukaar.moonlight.api.platform;

import com.mojang.serialization.DynamicOps;
import dev.architectury.injectables.annotations.ExpectPlatform;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1688;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2444;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2768;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_55;

/**
 * Helper class dedicated to platform forge specific methods. Usually fabric methods here just call vanilla stuff while forge have extra logic usually calling events
 */
public class ForgeHelper {

    @Deprecated(forRemoval = true)
    @ExpectPlatform
    public static class_2444 addRecipeConditions(class_2444 originalRecipe, List<Object> conditions) {
        throw new AssertionError();
    }

    public static <T> DynamicOps<T> addConditionOps(DynamicOps<T> ops) {
        return ops; //TODO: 1.20.4
    }

    @Contract
    @ExpectPlatform
    public static boolean onProjectileImpact(class_1676 improvedProjectileEntity, class_239 blockHitResult) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static boolean isCurativeItem(class_1799 stack, class_1293 effect) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static boolean canHarvestBlock(class_2680 state, class_3218 level, class_2338 pos, class_3222 player) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static float getFriction(class_2680 state, class_4538 level, class_2338 pos, @Nullable class_1297 entity) {
        throw new AssertionError();
    }


    @Contract
    @ExpectPlatform
    public static boolean canEquipItem(class_1309 entity, class_1799 stack, class_1304 slot) {
        throw new AssertionError();
    }

    @Contract
    @ExpectPlatform
    public static boolean canEntityDestroy(class_1937 level, class_2338 blockPos, class_1429 animal) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static boolean onExplosionStart(class_1937 level, class_1927 explosion) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void onLivingConvert(class_1309 frFom, class_1309 to) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static boolean canLivingConvert(class_1309 entity, class_1299<? extends class_1309> outcome, Consumer<Integer> timer) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void onExplosionDetonate(class_1937 level, class_1927 explosion, List<class_1297> entities, double diameter) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static double getReachDistance(class_1309 entity) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static float getExplosionResistance(class_2680 state, class_1937 level, class_2338 pos, class_1927 explosion) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void onBlockExploded(class_2680 blockstate, class_1937 level, class_2338 blockpos, class_1927 explosion) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static boolean areStacksEqual(class_1799 stack, class_1799 other, boolean sameNbt) {
        throw new AssertionError();
    }

    @Deprecated(forRemoval = true)
    public static boolean isFireSource(class_2680 blockState, class_1937 level, class_2338 pos, class_2350 up) {
        return PlatHelper.isFireSource(blockState, level, pos, up);
    }


    @ExpectPlatform
    public static boolean canDropFromExplosion(class_2680 blockstate, class_1937 level, class_2338 blockpos, class_1927 explosion) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static boolean isDye(class_1799 itemstack) {
        throw new AssertionError();
    }

    @org.jetbrains.annotations.Nullable
    @ExpectPlatform
    public static class_1767 getColor(class_1799 stack) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static class_2680 rotateBlock(class_2680 state, class_1937 world, class_2338 targetPos, class_2470 rot) {
        throw new AssertionError();
    }


    @Contract
    @ExpectPlatform
    public static boolean isMultipartEntity(class_1297 e) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void setPoolName(class_55.class_56 pool, String name) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static class_2768 getRailDirection(class_2241 railBlock, class_2680 blockstate, class_1937 level, class_2338 blockpos, @org.jetbrains.annotations.Nullable class_1688 o) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static Optional<class_1799> getCraftingRemainingItem(class_1799 itemstack) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void reviveEntity(class_1297 entity) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static boolean onCropsGrowPre(class_3218 level, class_2338 pos, class_2680 state, boolean b) {
        throw new AssertionError();

    }

    @ExpectPlatform
    public static void onCropsGrowPost(class_3218 level, class_2338 pos, class_2680 state) {
    }

    @ExpectPlatform
    public static void onEquipmentChange(class_1309 entity, class_1304 slot, class_1799 from, class_1799 to) {
    }

    @ExpectPlatform
    @org.jetbrains.annotations.Nullable
    public static class_1269 onRightClickBlock(class_1657 player, class_1268 hand, class_2338 below, class_3965 rayTraceResult) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static boolean canItemStack(class_1799 i, class_1799 i1) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static int getLightEmission(class_2680 state, class_1937 level, class_2338 pos) {
        throw new ArrayStoreException();
    }

    @ExpectPlatform
    public static Map<class_2248, class_1792> getBlockItemMap() {
        throw new AssertionError();
    }

    @Contract
    @ExpectPlatform
    public static boolean isInFluidThatCanExtinguish(class_1297 entity) {
        throw new AssertionError();
    }
}
