package net.mehvahdjukaar.moonlight.api.platform;

import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1813;
import net.minecraft.class_1826;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2362;
import net.minecraft.class_2400;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3288;
import net.minecraft.class_3302;
import net.minecraft.class_3414;
import net.minecraft.class_3908;
import net.minecraft.class_4174;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5455;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

/**
 * Helper class dedicated to platform independent common utility methods that require a different implementation for each loader
 * Forge specific methods that don't have a fabric equivalent are located in ForgeHelper
 */
public class PlatHelper {

    @ExpectPlatform
    public static void addCommonSetup(Runnable commonSetup) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void addCommonSetupAsync(Runnable commonSetup) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void addReloadableCommonSetup(BiConsumer<class_5455, Boolean> setup) {
        throw new AssertionError();
    }

    @Contract
    @ExpectPlatform
    public static boolean isDev() {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static boolean isData() {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static boolean isModLoadingValid() {
        throw new AssertionError();
    }

    /**
     * If loaders are during standard mod init phase
     */
    @ExpectPlatform
    public static boolean isInitializing(){
        throw new AssertionError();
    }

    @ExpectPlatform
    public static boolean evaluateRecipeCondition(JsonElement jo) {
        throw new AssertionError();
    }

    @Contract
    @ExpectPlatform
    public static void invokeLevelUnload(class_1937 l) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static boolean isFakePlayer(class_3222 instance) {
        throw new AssertionError();
    }

    public enum Platform {
        FORGE, FABRIC;
        private static boolean quilt = false;

        static {
            try {
                Class.forName("org.quiltmc.loader.api.QuiltLoader");
                quilt = true;
            } catch (ClassNotFoundException ignored) {
            }
        }

        public boolean isForge() {
            return this == FORGE;
        }

        public boolean isFabric() {
            return this == FABRIC;
        }

        public boolean isQuilt() {
            return isFabric() && quilt;
        }

        public void ifForge(Runnable runnable) {
            if (isForge()) runnable.run();
        }

        public void ifFabric(Runnable runnable) {
            if (isFabric()) runnable.run();
        }
    }

    @Contract
    @ExpectPlatform
    public static Platform getPlatform() {
        throw new AssertionError();
    }

    public enum Side {
        CLIENT, SERVER;

        public boolean isClient() {
            return this == CLIENT;
        }

        public boolean isServer() {
            return this == SERVER;
        }

        public void ifClient(Runnable runnable) {
            if (isClient()) runnable.run();
        }

        public void ifServer(Runnable runnable) {
            if (isServer()) runnable.run();
        }
    }

    @Contract
    @ExpectPlatform
    public static Side getPhysicalSide() {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static Path getGamePath() {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static Path getModFilePath(String modId) {
        throw new AssertionError();
    }

    @Nullable
    @ExpectPlatform
    public static String getModPageUrl(String modId) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static String getModName(String modId) {
        throw new AssertionError();
    }

    @Nullable
    @ExpectPlatform
    public static <T> Field findField(Class<? super T> clazz, String fieldName) {
        throw new AssertionError();
    }

    @Nullable
    @ExpectPlatform
    public static Method findMethod(Class<?> clazz, String methodName, Class<?>... parameterTypes) {
        throw new AssertionError();
    }

    @Nullable
    @ExpectPlatform
    public static MinecraftServer getCurrentServer() {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static boolean isModLoaded(String modId) {
        throw new AssertionError();
    }

    @Nullable
    @ExpectPlatform
    public static String getModVersion(String modId) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static List<String> getInstalledMods() {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void registerResourcePack(class_3264 packType, Supplier<class_3288> packSupplier) {
        throw new AssertionError();
    }


    @Contract
    @ExpectPlatform
    public static boolean isMobGriefingOn(class_1937 level, class_1297 entity) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static boolean isAreaLoaded(class_4538 level, class_2338 pos, int maxRange) {
        throw new AssertionError();
    }

    @ExpectPlatform
    @Nullable
    public static class_4174 getFoodProperties(class_1792 food, class_1799 stack, class_1657 player) {
        throw new AssertionError();
    }


    @ExpectPlatform
    public static int getBurnTime(class_1799 stack) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static boolean isFireSource(class_2680 blockState, class_1937 level, class_2338 pos, class_2350 up) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static int getFireSpreadSpeed(class_2680 state, class_1922 level, class_2338 pos, class_2350 direction){
        throw new AssertionError();
    }

    @ExpectPlatform
    public static int getFlammability(class_2680 state, class_1922 level, class_2338 pos, class_2350 direction) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static class_2596<class_2602> getEntitySpawnPacket(class_1297 entity) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static class_1826 newSpawnEgg(Supplier<? extends class_1299<? extends class_1308>> entityType, int color, int outerColor, class_1792.class_1793 properties) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static class_2362 newFlowerPot(@Nullable Supplier<class_2362> emptyPot, Supplier<? extends class_2248> supplier, class_4970.class_2251 properties) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static class_1813 newMusicDisc(int power, Supplier<class_3414> music, class_1792.class_1793 properties, int secondDuration) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static class_2400 newParticle() {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static <T extends class_2586> class_2591<T> newBlockEntityType(BlockEntitySupplier<T> blockEntitySupplier, class_2248... validBlocks) {
        throw new AssertionError();
    }

    @FunctionalInterface
    public interface BlockEntitySupplier<T extends class_2586> {
        @NotNull T create(class_2338 pos, class_2680 state);
    }

    @ExpectPlatform
    public static <E extends class_1297> class_1299<E> newEntityType(String name,
                                                                 class_1299.class_4049<E> factory, class_1311 category, float width, float height,
                                                                 int clientTrackingRange, boolean velocityUpdates, int updateInterval) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void addServerReloadListener(class_3302 listener, class_2960 location) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void openCustomMenu(class_3222 player, class_3908 menuProvider, Consumer<class_2540> extraDataProvider) {
        throw new AssertionError();
    }

    public static void openCustomMenu(class_3222 player, class_3908 menuProvider, class_2338 pos) {
        openCustomMenu(player, menuProvider, buf -> buf.method_10807(pos));
    }

    @ExpectPlatform
    public static class_1657 getFakeServerPlayer(GameProfile id, class_3218 level) {
        throw new AssertionError();
    }

}
