package net.mehvahdjukaar.moonlight.api.platform;

import com.google.common.collect.ImmutableSet;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.Codec;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.mehvahdjukaar.moonlight.api.block.ModStairBlock;
import net.mehvahdjukaar.moonlight.api.item.FuelBlockItem;
import net.mehvahdjukaar.moonlight.api.misc.QuadConsumer;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.misc.TriFunction;
import net.mehvahdjukaar.moonlight.api.util.DispenserHelper;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1428;
import net.minecraft.class_1453;
import net.minecraft.class_1496;
import net.minecraft.class_1535;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1781;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2400;
import net.minecraft.class_2482;
import net.minecraft.class_2540;
import net.minecraft.class_2544;
import net.minecraft.class_2582;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2941;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3414;
import net.minecraft.class_3611;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_3962;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4158;
import net.minecraft.class_4168;
import net.minecraft.class_4170;
import net.minecraft.class_4970;
import net.minecraft.class_5132;
import net.minecraft.class_5321;
import net.minecraft.class_7151;
import net.minecraft.class_7157;
import net.minecraft.class_7706;
import net.minecraft.class_7924;
import net.minecraft.world.entity.*;
import net.minecraft.world.item.*;
import net.minecraft.world.item.crafting.*;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.function.*;

/**
 * Helper class dedicated to platform independent registration methods
 */
public class RegHelper {

    @ExpectPlatform
    public static <T, E extends T> RegSupplier<E> register(
            class_2960 name, Supplier<E> supplier, class_5321<? extends class_2378<T>> regKey) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static <T> void registerInBatch(class_2378<T> reg, Consumer<Registrator<T>> eventListener) {
        throw new AssertionError();
    }

    /**
     * Registers stuff immediately on fabric. Normal behavior for forge
     */
    @ExpectPlatform
    public static <T, E extends T> RegSupplier<E> registerAsync(class_2960 name, Supplier<E> supplier, class_5321<? extends class_2378<T>> regKey) {
        throw new AssertionError();
    }

    public static <T extends class_2248> RegSupplier<T> registerBlock(class_2960 name, Supplier<T> block) {
        return register(name, block, class_7924.field_41254);
    }

    //helpers
    public static <T extends class_2248> RegSupplier<T> registerBlockWithItem(class_2960 name, Supplier<T> blockFactory) {
        return registerBlockWithItem(name, blockFactory, 0);
    }

    public static <T extends class_2248> RegSupplier<T> registerBlockWithItem(class_2960 name, Supplier<T> blockFactory, int burnTime) {
        return registerBlockWithItem(name, blockFactory, new class_1792.class_1793(), burnTime);
    }

    public static <T extends class_2248> RegSupplier<T> registerBlockWithItem(class_2960 name, Supplier<T> blockFactory, class_1792.class_1793 properties, int burnTime) {
        RegSupplier<T> block = registerBlock(name, blockFactory);
        registerItem(name, () -> {
            if (burnTime == 0) return new class_1747(block.get(), properties);
            else return new FuelBlockItem(block.get(), properties, () -> burnTime);
        });
        return block;
    }

    @ExpectPlatform
    public static <T> Supplier<class_2941<T>> regEntityDataSerializer(class_2960 name, Supplier<class_2941<T>> serializer) {
        throw new AssertionError();
    }

    public static RegSupplier<class_4158> registerPOI(class_2960 name, Supplier<class_4158> poi) {
        return register(name, poi, class_7924.field_41212);
    }

    public static RegSupplier<class_4158> registerPOI(class_2960 name, int searchDistance, int maxTickets, class_2248... blocks) {
        return registerPOI(name, () -> {
            ImmutableSet.Builder<class_2680> builder = ImmutableSet.builder();
            for (class_2248 block : blocks) {
                builder.addAll(block.method_9595().method_11662());
            }
            return new class_4158(builder.build(), searchDistance, maxTickets);
        });
    }

    public static RegSupplier<class_4158> registerPOI(class_2960 name, int searchDistance, int maxTickets, Supplier<class_2248>... blocks) {
        return registerPOI(name, () -> {
            ImmutableSet.Builder<class_2680> builder = ImmutableSet.builder();
            for (var block : blocks) {
                builder.addAll(block.get().method_9595().method_11662());
            }
            return new class_4158(builder.build(), searchDistance, maxTickets);
        });
    }

    //call in setup when you have blocks
    @ExpectPlatform
    public static void addBlocksToPOI(class_5321<class_4158> poi, Iterable<? extends class_2248> blocks) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static <T extends class_3611> RegSupplier<T> registerFluid(class_2960 name, Supplier<T> fluid) {
        throw new AssertionError();
    }

    public static <T extends class_1792> RegSupplier<T> registerItem(class_2960 name, Supplier<T> item) {
        return register(name, item, class_7924.field_41197);
    }

    public static <T extends class_3031<?>> RegSupplier<T> registerFeature(class_2960 name, Supplier<T> feature) {
        return register(name, feature, class_7924.field_41267);
    }

    public static <T extends class_7151<?>> RegSupplier<T> registerStructure(class_2960 name, Supplier<T> feature) {
        //TODO: this causes issues on fabric and its very random as might be on only with some random unrelated mods. best to lave it like this
        // return register(name, feature, Registry.STRUCTURE_TYPES);
        return registerAsync(name, feature, class_7924.field_41231);
    }


    public static <T extends class_3414> RegSupplier<T> registerSound(class_2960 name, Supplier<T> sound) {
        return register(name, sound, class_7924.field_41225);
    }

    public static RegSupplier<class_3414> registerSound(class_2960 name) {
        return registerSound(name, () -> class_3414.method_47908(name));
    }

    public static RegSupplier<class_3414> registerSound(class_2960 name, float fixedRange) {
        return registerSound(name, () -> class_3414.method_47909(name, fixedRange));
    }

    public static <T extends class_1535> RegSupplier<T> registerPainting(class_2960 name, Supplier<T> painting) {
        return register(name, painting, class_7924.field_41209);
    }

    @ExpectPlatform
    public static <C extends class_1703> RegSupplier<class_3917<C>> registerMenuType(
            class_2960 name,
            TriFunction<Integer, class_1661, class_2540, C> containerFactory) {
        throw new AssertionError();
    }

    public static <T extends class_1291> RegSupplier<T> registerEffect(class_2960 name, Supplier<T> effect) {
        return register(name, effect, class_7924.field_41208);
    }

    public static <T extends class_1887> RegSupplier<T> registerEnchantment(class_2960 name, Supplier<T> enchantment) {
        return register(name, enchantment, class_7924.field_41265);
    }

    public static <T extends class_4149<? extends class_4148<?>>> RegSupplier<T> registerSensor(class_2960 name, Supplier<T> sensorType) {
        return register(name, sensorType, class_7924.field_41221);
    }

    public static <T extends class_4148<?>> RegSupplier<class_4149<T>> registerSensorI(class_2960 name, Supplier<T> sensor) {
        return register(name, () -> new class_4149<>(sensor), class_7924.field_41221);
    }

    public static <T extends class_4168> RegSupplier<T> registerActivity(class_2960 name, Supplier<T> activity) {
        return register(name, activity, class_7924.field_41222);
    }

    public static RegSupplier<class_4168> registerActivity(class_2960 name) {
        return registerActivity(name, () -> new class_4168(name.method_12832()));
    }

    public static <T extends class_4170> RegSupplier<T> registerSchedule(class_2960 name, Supplier<T> schedule) {
        return register(name, schedule, class_7924.field_41220);
    }

    public static <T extends class_4140<?>> RegSupplier<T> registerMemoryModule(class_2960 name, Supplier<T> memory) {
        return register(name, memory, class_7924.field_41206);
    }

    public static <U> RegSupplier<class_4140<U>> registerMemoryModule(class_2960 name, @Nullable Codec<U> codec) {
        return register(name, () -> new class_4140<>(Optional.ofNullable(codec)), class_7924.field_41206);
    }

    public static <T extends class_1865<?>> RegSupplier<T> registerRecipeSerializer(class_2960 name, Supplier<T> recipe) {
        return register(name, recipe, class_7924.field_41216);
    }

    @ExpectPlatform
    public static <T extends class_3955> RegSupplier<class_1865<T>> registerSpecialRecipe(class_2960 name, class_1866.class_7711<T> factory) {
        throw new AssertionError();
    }

    public static <T extends class_1860<?>> Supplier<class_3956<T>> registerRecipeType(class_2960 name) {
        return RegHelper.register(name, () -> {
            String id = name.toString();
            return new class_3956<T>() {
                @Override
                public String toString() {
                    return id;
                }
            };
        }, class_7924.field_41217);
    }

    public static <T extends class_2591<E>, E extends class_2586> RegSupplier<T> registerBlockEntityType(class_2960 name,
                                                                                                               Supplier<T> blockEntity) {
        return register(name, blockEntity, class_7924.field_41255);
    }

    public static <E extends class_2586> RegSupplier<class_2591<E>> registerBlockEntityType(
            class_2960 name, BiFunction<class_2338, class_2680, E> blockEntitySupplier, class_2248... blocks) {
        return registerBlockEntityType(name, () -> PlatHelper.newBlockEntityType(blockEntitySupplier::apply, blocks));
    }

    public static <E extends class_2586> RegSupplier<class_2591<E>> registerBlockEntityType(
            class_2960 name, BiFunction<class_2338, class_2680, E> blockEntitySupplier, Supplier<class_2248>... blocks) {
        return registerBlockEntityType(name, () -> PlatHelper.newBlockEntityType(blockEntitySupplier::apply,
                Arrays.stream(blocks).map(Supplier::get).toArray(class_2248[]::new)));
    }

    public static RegSupplier<class_2400> registerParticle(class_2960 name) {
        return register(name, PlatHelper::newParticle, class_7924.field_41210);
    }


    public static RegSupplier<class_2582> registerBannerPattern(class_2960 name) {
        return registerBannerPattern(name, name.toString());
    }

    @Deprecated(forRemoval = true)
    public static RegSupplier<class_2582> registerBannerPattern(class_2960 name, String patternId) {
        return register(name, () -> new class_2582(patternId), class_7924.field_41252);
    }

    public static <T extends class_1297> RegSupplier<class_1299<T>> registerEntityType(class_2960 name, class_1299.class_4049<T> factory,
                                                                                   class_1311 category, float width, float height) {
        return registerEntityType(name, factory, category, width, height, 5);
    }

    //not needed?
    public static <T extends class_1297> RegSupplier<class_1299<T>> registerEntityType(class_2960 name, class_1299.class_4049<T> factory,
                                                                                   class_1311 category, float width,
                                                                                   float height, int clientTrackingRange) {
        return registerEntityType(name, factory, category, width, height, clientTrackingRange, 3);
    }

    @ExpectPlatform
    public static <T extends class_1297> RegSupplier<class_1299<T>> registerEntityType(class_2960 name, class_1299.class_4049<T> factory,
                                                                                   class_1311 category, float width, float height,
                                                                                   int clientTrackingRange, int updateInterval) {
        throw new AssertionError();
    }

    public static <T extends class_1297> RegSupplier<class_1299<T>> registerEntityType(class_2960 name, Supplier<class_1299<T>> type) {
        return register(name, type, class_7924.field_41266);
    }

    public static void registerCompostable(class_1935 itemLike, float chance) {
        class_3962.field_17566.put(itemLike.method_8389(), chance);
    }

    @ExpectPlatform //fabric
    public static void registerItemBurnTime(class_1792 item, int burnTime) {
        throw new AssertionError();
    }

    @ExpectPlatform //Works on both. On forge, however, consider using block method overrides
    public static void registerBlockFlammability(class_2248 item, int fireSpread, int flammability) {
        throw new AssertionError();
    }

    @Deprecated(forRemoval = true)
    @ExpectPlatform
    public static void registerVillagerTrades(class_3852 profession, int level, Consumer<List<class_3853.class_1652>> factories) {
        throw new AssertionError();
    }

    @Deprecated(forRemoval = true)
    @ExpectPlatform
    public static void registerWanderingTraderTrades(int level, Consumer<List<class_3853.class_1652>> factories) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void registerSimpleRecipeCondition(class_2960 id, Predicate<String> predicate) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static RegSupplier<class_1761> registerCreativeModeTab(
            class_2960 name,
            boolean searchBar,
            List<class_2960> afterTabs, List<class_2960> beforeTabs, Consumer<class_1761.class_7913> configurator
    ) {
        throw new AssertionError();
    }

    private static final List<class_2960> DEFAULT_AFTER_ENTRIES = List.of(class_7706.field_40205.method_29177());

    public static RegSupplier<class_1761> registerCreativeModeTab(class_2960 name, Consumer<class_1761.class_7913> configurator) {
        return registerCreativeModeTab(name, false, configurator);
    }

    public static RegSupplier<class_1761> registerCreativeModeTab(class_2960 name, boolean searchBar, Consumer<class_1761.class_7913> configurator) {
        return registerCreativeModeTab(name, searchBar, DEFAULT_AFTER_ENTRIES, List.of(), configurator);
    }

    @ExpectPlatform
    public static void addItemsToTabsRegistration(Consumer<ItemToTabEvent> event) {
        throw new AssertionError();
    }

    public record ItemToTabEvent(
            QuadConsumer<class_5321<class_1761>, @Nullable Predicate<class_1799>, Boolean, Collection<class_1799>> action) {


        public void add(class_5321<class_1761> tab, class_1935... items) {
            addAfter(tab, null, items);
        }

        public void add(class_5321<class_1761> tab, class_1799... items) {
            addAfter(tab, null, items);
        }

        public void addAfter(class_5321<class_1761> tab, Predicate<class_1799> target, class_1935... items) {
            List<class_1799> stacks = new ArrayList<>();
            for (var i : items) {
                if (i.method_8389().method_7854().method_7960()) {
                    if (PlatHelper.isDev())
                        throw new IllegalStateException("Attempted to add empty item " + i + " to item tabs");
                } else stacks.add(i.method_8389().method_7854());
            }
            action.accept(tab, target, true, stacks);
        }

        public void addAfter(class_5321<class_1761> tab, Predicate<class_1799> target, class_1799... items) {
            action.accept(tab, target, true, java.util.List.of(items));
        }

        public void addBefore(class_5321<class_1761> tab, Predicate<class_1799> target, class_1935... items) {
            List<class_1799> stacks = new ArrayList<>();
            for (var i : items) {
                if (i.method_8389().method_7854().method_7960()) {
                    if (PlatHelper.isDev())
                        throw new IllegalStateException("Attempted to add empty item " + i + " to item tabs");
                } else stacks.add(i.method_8389().method_7854());
            }
            action.accept(tab, target, false, stacks);
        }

        public void addBefore(class_5321<class_1761> tab, Predicate<class_1799> target, class_1799... items) {
            action.accept(tab, target, false, java.util.List.of(items));
        }
    }

    @FunctionalInterface
    public interface AttributeEvent {
        void register(class_1299<? extends class_1309> type, class_5132.class_5133 builder);
    }

    @ExpectPlatform
    public static void addAttributeRegistration(Consumer<AttributeEvent> eventListener) {
        throw new AssertionError();
    }

    @FunctionalInterface
    public interface SpawnPlacementEvent {
        <T extends class_1297> void register(class_1299<T> entityType, class_1317.class_1319 decoratorType,
                                         class_2902.class_2903 heightMapType, class_1317.class_4306<T> decoratorPredicate);
    }

    @ExpectPlatform
    public static void addSpawnPlacementsRegistration(Consumer<SpawnPlacementEvent> eventListener) {
        throw new AssertionError();
    }

    @FunctionalInterface
    public interface CommandRegistration {
        void accept(CommandDispatcher<class_2168> dispatcher, class_7157 context, class_2170.class_5364 selection);
    }

    @ExpectPlatform
    public static void addCommandRegistration(CommandRegistration eventListener) {
        throw new AssertionError();
    }

    public enum VariantType {
        BLOCK(class_2248::new),
        STAIRS(ModStairBlock::new),
        SLAB(class_2482::new),
        WALL(class_2544::new);
        private final BiFunction<Supplier<class_2248>, class_4970.class_2251, class_2248> constructor;

        VariantType(BiFunction<Supplier<class_2248>, class_4970.class_2251, class_2248> constructor) {
            this.constructor = constructor;
        }

        VariantType(Function<class_4970.class_2251, class_2248> constructor) {
            this.constructor = (b, p) -> constructor.apply(p);
        }

        public class_2248 create(class_4970.class_2251 properties, @Nullable Supplier<class_2248> parent) {
            return this.constructor.apply(parent, properties);
        }

        public static void addToTab(ItemToTabEvent event, Map<VariantType, Supplier<class_2248>> blocks) {
            Map<VariantType, Supplier<class_2248>> m = new EnumMap<>(blocks);
            event.add(class_7706.field_40195, m.values().stream().map(Supplier::get).toArray(class_2248[]::new));
        }

    }

    public static EnumMap<VariantType, Supplier<class_2248>> registerBaseBlockSet(class_2960 baseName, class_2248 parentBlock) {
        return registerBaseBlockSet(baseName, class_4970.class_2251.method_9630(parentBlock));
    }

    /**
     * Registers block, slab and vertical slab
     */
    public static EnumMap<VariantType, Supplier<class_2248>> registerBaseBlockSet(
            class_2960 baseName, class_4970.class_2251 properties) {
        return registerBlockSet(new VariantType[]{VariantType.BLOCK, VariantType.SLAB}, baseName, properties);
    }

    public static EnumMap<VariantType, Supplier<class_2248>> registerReducedBlockSet(class_2960 baseName, class_2248 parentBlock) {
        return registerReducedBlockSet(baseName, class_4970.class_2251.method_9630(parentBlock));
    }

    /**
     * Registers block, slab stairs and vertical slab
     */
    public static EnumMap<VariantType, Supplier<class_2248>> registerReducedBlockSet(
            class_2960 baseName, class_4970.class_2251 properties) {
        return registerBlockSet(new VariantType[]{VariantType.BLOCK, VariantType.STAIRS, VariantType.SLAB}, baseName, properties);
    }

    public static EnumMap<VariantType, Supplier<class_2248>> registerFullBlockSet(class_2960 baseName,
                                                                             class_2248 parentBlock) {
        return registerFullBlockSet(baseName, class_4970.class_2251.method_9630(parentBlock));
    }

    /**
     * Utility to register a full block set
     *
     * @return registry object map
     */
    public static EnumMap<VariantType, Supplier<class_2248>> registerFullBlockSet(
            class_2960 baseName, class_4970.class_2251 properties) {
        return registerBlockSet(VariantType.values(), baseName, properties);
    }

    public static EnumMap<VariantType, Supplier<class_2248>> registerBlockSet(
            VariantType[] types, class_2960 baseName, class_4970.class_2251 properties) {

        if (!new ArrayList<>(List.of(types)).contains(VariantType.BLOCK))
            throw new IllegalStateException("Must contain base variant type");

        var block = registerBlock(baseName, () -> VariantType.BLOCK.create(properties, null));
        registerItem(baseName, () -> new class_1747(block.get(), (new class_1792.class_1793())));

        var m = registerBlockSet(types, block, baseName.method_12836());
        m.put(VariantType.BLOCK, block);
        return m;
    }

    public static EnumMap<VariantType, Supplier<class_2248>> registerBlockSet(
            VariantType[] types, RegSupplier<? extends class_2248> baseBlock, String modId) {

        class_2960 baseName = baseBlock.getId();
        EnumMap<VariantType, Supplier<class_2248>> map = new EnumMap<>(VariantType.class);
        for (VariantType type : types) {
            if (type.equals(VariantType.BLOCK)) continue;
            String name = baseName.method_12832();
            name += "_" + type.name().toLowerCase(Locale.ROOT);
            class_2960 blockId = new class_2960(modId, name);
            var block = registerBlock(blockId, () ->
                    type.create(class_4970.class_2251.method_9630(baseBlock.get()), baseBlock::get));
            registerItem(blockId, () -> new class_1747(block.get(), new class_1792.class_1793()));
            map.put(type, block);
        }
        return map;
    }

    public interface LootInjectEvent {
        class_2960 getTable();

        void addTableReference(class_2960 targetId);
    }

    /**
     * This uses fabric loot modify event and something equivalent to the old forge loot modift event.
     * It simply adds a loot table reference pool to the target table
     *
     * @param eventListener function that takes in the original table id and spits out the table reference id. Return null for no op
     */
    @ExpectPlatform
    public static void addLootTableInjects(Consumer<LootInjectEvent> eventListener) {
        throw new AssertionError();
    }


    public static void addDynamicDispenserBehaviorRegistration(Consumer<DispenserHelper.Event> eventListener) {
        DispenserHelper.addListener(eventListener, DispenserHelper.Priority.NORMAL);
    }

    public static void addDynamicDispenserBehaviorRegistration(Consumer<DispenserHelper.Event> eventListener, DispenserHelper.Priority priority) {
        DispenserHelper.addListener(eventListener, priority);
    }

    // Animal food stuff

    public static void registerChickenFood(class_1935... food) {
        List<class_1799> chickenFood = new ArrayList<>(List.of(class_1428.field_6742.method_8105()));
        Arrays.stream(food).forEach(f -> chickenFood.add(f.method_8389().method_7854()));
        class_1428.field_6742 = class_1856.method_26964(chickenFood.stream());
    }

    public static void registerHorseFood(class_1935... food) {
        List<class_1799> horseFood = new ArrayList<>(List.of(class_1496.field_25374.method_8105()));
        Arrays.stream(food).forEach(f -> horseFood.add(f.method_8389().method_7854()));
        class_1496.field_25374 = class_1856.method_26964(horseFood.stream());
    }

    public static void registerParrotFood(class_1935... food) {
        Arrays.stream(food).forEach(f -> class_1453.field_6825.add(f.method_8389()));
    }

    // Only relevant on forge
    @ExpectPlatform
    public static void registerFireworkRecipe(class_1781.class_1782 shape, class_1792 ingredient) {
        throw new AssertionError();
    }

}



