package net.mehvahdjukaar.moonlight.api.platform.network;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Function;
import java.util.function.IntSupplier;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

/**
 * Your main network channel instance.
 */
//TODO: rename
public abstract class ChannelHandler {

    public static Builder builder(String modId) {
        return new Builder(modId);
    }

    public static class Builder {
        private final ChannelHandler instance;
        private int version = 0;

        protected Builder(String modId) {
            instance = createChannel(modId, () -> version);
        }

        public <M extends Message> Builder register(
                NetworkDir direction,
                Class<M> messageClass,
                Function<class_2540, M> decoder) {
            instance.register(direction, messageClass, decoder);
            return this;
        }

        public Builder version(int version) {
            this.version = version;
            return this;
        }

        public ChannelHandler build() {
            return instance;
        }
    }

    @Deprecated(forRemoval = true)
    public static ChannelHandler createChannel(class_2960 channelMame, int version) {
        return createChannel(channelMame.method_12836(), () -> version);
    }

    @Deprecated(forRemoval = true)
    public static ChannelHandler createChannel(class_2960 channelMame) {
        return createChannel(channelMame, 1);
    }

    public static ChannelHandler createChannel(String modId) {
        return createChannel(modId, () -> 0);
    }

    @ExpectPlatform
    public static ChannelHandler createChannel(String modId, IntSupplier version) {
        throw new AssertionError();
    }

    protected final String name;

    protected ChannelHandler(String modId) {
        this.name = modId;
    }

    @Deprecated
    public abstract <M extends Message> void register(
            NetworkDir direction,
            Class<M> messageClass,
            Function<class_2540, M> decoder);


    public interface Context {
        NetworkDir getDirection();

        class_1657 getSender();

        void disconnect(class_2561 reason);
    }


    public abstract void sendToClientPlayer(class_3222 serverPlayer, Message message);

    public abstract void sendToAllClientPlayers(Message message);

    public abstract void sendToAllClientPlayersInRange(class_1937 level, class_2338 pos, double radius, Message message);

    public void sendToAllClientPlayersInDefaultRange(class_1937 level, class_2338 pos, Message message){
        sendToAllClientPlayersInRange(level, pos, 64, message);
    }

    // same distance as serverlevel send particles
    public void sendToAllClientPlayersInParticleRange(class_1937 level, class_2338 pos, Message message){
        sendToAllClientPlayersInRange(level, pos, 32, message);
    }

    public void sendToAllClientPlayersInDistantParticleRange(class_1937 level, class_2338 pos, Message message){
        sendToAllClientPlayersInRange(level, pos, 512, message);
    };

    public abstract void sentToAllClientPlayersTrackingEntity(class_1297 target, Message message);

    public abstract void sentToAllClientPlayersTrackingEntityAndSelf(class_1297 target, Message message);

    public abstract void sendToServer(Message message);

}
