package net.mehvahdjukaar.moonlight.api.resources;

import com.google.gson.JsonObject;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;

/**
 * Represents a generic resource that can be read multiple times. Consumes the original resource
 */
public class StaticResource {
    public final byte[] data;
    public final class_2960 location;
    public final String sourceName;

    private String dataAsString = null;

    private StaticResource(byte[] data, class_2960 location, String sourceName) {
        this.data = data;
        this.location = location;
        this.sourceName = sourceName;
    }

    /**
     * Converts and consume a resource to be used multiple time
     */
    public static StaticResource of(class_3298 original, class_2960 location) {
        byte[] data1 = new byte[]{};
        try (var stream = original.method_14482()) {
            try {
                data1 = stream.readAllBytes();
            } catch (IOException e) {
                Moonlight.LOGGER.error("Could not parse resource: {}", location);
            }
        } catch (Exception ignored) {}

        return new StaticResource(data1, location, original.method_14480());
    }

    /**
     * Just used as a record
     */
    public static StaticResource create(byte[] data, class_2960 location) {
        return new StaticResource(data, location, location.toString());
    }

    @Nullable
    public static StaticResource getOrLog(class_3300 manager, class_2960 location) {
        try {
            return of(manager.method_14486(location).get(),location);
        } catch (Exception var4) {
            Moonlight.LOGGER.error("Could not find resource {}", location);
            return null;
        }
    }

    @Deprecated(forRemoval = true)
    public static StaticResource getOrFail(class_3300 manager, class_2960 location) throws NoSuchElementException {
        return of(manager.method_14486(location).orElseThrow(), location);
    }

    public static StaticResource getOrThrow(class_3300 manager, class_2960 location) throws NoSuchElementException {
        return of(manager.method_14486(location).orElseThrow(), location);
    }

    public JsonObject toJson(){
        try(var s = new ByteArrayInputStream(data)){
            return RPUtils.deserializeJson(s);
        }
        catch (Exception e){
            throw  new RuntimeException(e);
        }
    }

    public String asString() {
        if (this.dataAsString == null) {
            this.dataAsString = new String(this.data, StandardCharsets.UTF_8);
        }
        return this.dataAsString;
    }
}