package net.mehvahdjukaar.moonlight.api.resources.pack;

import ;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.gson.JsonElement;
import dev.architectury.injectables.annotations.PlatformOnly;
import net.mehvahdjukaar.moonlight.api.integration.ModernFixCompat;
import net.mehvahdjukaar.moonlight.api.misc.PathTrie;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.core.CommonConfigs;
import net.mehvahdjukaar.moonlight.core.CompatHandler;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3272;
import net.minecraft.class_3274;
import net.minecraft.class_3288;
import net.minecraft.class_5321;
import net.minecraft.class_5352;
import net.minecraft.class_7367;
import net.minecraft.class_7699;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public abstract class DynamicResourcePack implements class_3262 {

    protected static final Logger LOGGER = LogManager.getLogger();

    protected final boolean hidden;
    protected final boolean fixed;
    protected final class_3288.class_3289 position;
    protected final class_3264 packType;
    protected final Supplier<class_3272> metadata;
    protected final class_2561 title;
    protected final class_2960 resourcePackName;
    protected final Set<String> namespaces = new HashSet<>();
    protected final Map<class_2960, byte[]> resources = new ConcurrentHashMap<>();
    protected final ResourceLocPathTrie searchTrie = new ResourceLocPathTrie();
    protected final Map<String, byte[]> rootResources = new ConcurrentHashMap<>();
    protected final String mainNamespace;

    protected Set<class_2960> staticResources = new HashSet<>();

    //for debug or to generate assets
    protected boolean generateDebugResources;
    private boolean needsClearingNonStatic = false;
    boolean addToStatic = false;
    private boolean wasRegistered = false;

    protected DynamicResourcePack(class_2960 name, class_3264 type) {
        this(name, type, class_3288.class_3289.field_14280, false, false);
    }

    protected DynamicResourcePack(class_2960 name, class_3264 type, class_3288.class_3289 position, boolean fixed, boolean hidden) {
        this.packType = type;
        this.resourcePackName = name;
        this.mainNamespace = name.method_12836();
        this.namespaces.add(mainNamespace);
        this.title = class_2561.method_43471(LangBuilder.getReadableName(name.toString()));

        this.position = position;
        this.fixed = fixed;
        this.hidden = hidden; //UNUSED. TODO: re add (forge)
        this.metadata = Suppliers.memoize(() -> new class_3272(this.makeDescription(),
                class_155.method_16673().method_48017(type)));
        this.generateDebugResources = PlatHelper.isDev();
    }

    public class_2561 makeDescription() {
        return class_2561.method_43471(LangBuilder.getReadableName(mainNamespace + "_dynamic_resources"));
    }

    @Deprecated(forRemoval = true)
    public void setClearOnReload(boolean canBeCleared) {
    }

    @Deprecated(forRemoval = true)
    public void clearOnReload(boolean canBeCleared) {
    }

    public void markNotClearable(class_2960 staticResources) {
        this.staticResources.add(staticResources);
    }

    public void unMarkNotClearable(class_2960 staticResources) {
        this.staticResources.remove(staticResources);
    }

    public void setGenerateDebugResources(boolean generateDebugResources) {
        this.generateDebugResources = generateDebugResources;
    }

    /**
     * Dynamic textures are loaded after getNamespaces is called, so unfortunately we need to know those in advance
     * Call this if you are adding stuff for another mod namespace
     **/
    public void addNamespaces(String... namespaces) {
        this.namespaces.addAll(Arrays.asList(namespaces));
    }

    public class_2561 getTitle() {
        return this.title;
    }

    @Override
    public String method_14409() {
        return title.getString();
    }

    public class_2960 id() {
        return resourcePackName;
    }

    @Override
    public String toString() {
        return method_14409();
    }

    /**
     * Registers this pack. Call on mod init
     */
    protected void registerPack() {
        if (wasRegistered) {
            return;
        } else {
            wasRegistered = true;
        }
        PlatHelper.registerResourcePack(this.packType, () ->
                class_3288.method_14456(
                        this.method_14409(),    // id
                        this.getTitle(), // title
                        true,    // required -- this MAY need to be true for the pack to be enabled by default
                        (s) -> this, // pack supplier
                        new class_3288.class_7679(metadata.get().method_14423(), metadata.get().method_14424(), class_7699.method_45397()), // description
                        this.packType,
                        class_3288.class_3289.field_14280,
                        this.fixed, // fixed position? no
                        class_5352.field_25348));

    }

    //@Override
    @PlatformOnly(PlatformOnly.FORGE)
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public Set<String> method_14406(class_3264 packType) {
        return this.namespaces;
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T> T method_14407(class_3270<T> serializer) {
        return serializer instanceof class_3274 ? (T) this.metadata : null;
    }

    public void addRootResource(String name, byte[] resource) {
        this.rootResources.put(name, resource);
    }

    @Nullable
    @Override
    public class_7367<InputStream> method_14410(String... strings) {
        String fileName = String.join("/", strings);
        byte[] resource = this.rootResources.get(fileName);
        return resource == null ? null : () -> new ByteArrayInputStream(resource);
    }


    @Override
    public void method_14408(class_3264 packType, String namespace, String id, class_7664 output) {

        if (PlatHelper.isDev()) {
            //validate
            for (var r : this.searchTrie.search("")) {
                if (!resources.containsKey(r)) {
                    Moonlight.LOGGER.error("Resource {} not ", r);
                    throw new IllegalStateException("Resource " + r + " not found in resources");
                }
            }
        }
        synchronized (this) {
            //why are we only using server resources here?
            if (packType == this.packType) {
                //idk why but somebody had an issue with concurrency here during world load

                this.searchTrie.search(namespace + "/" + id)
                        .forEach(r -> {
                            byte[] buf = resources.get(r);
                            if (buf == null) {
                                throw new IllegalStateException("Somehow search trie returned a resource not in resources " + r);
                            }
                            output.accept(r, () -> new ByteArrayInputStream(buf));
                        });
            }
        }
    }

    @Override
    public class_7367<InputStream> method_14405(class_3264 type, class_2960 id) {

        var res = this.resources.get(id);
        if (res != null) {
            return () -> {
                if (type != this.packType) {
                    throw new IOException(String.format("Tried to access wrong type of resource on %s.", this.resourcePackName));
                }
                return new ByteArrayInputStream(res);
            };
        }
        return null;
    }

    @Override
    public void close() {
        // do not clear after reloading texture packs. should always be on
    }

    public FileNotFoundException makeFileNotFoundException(String path) {
        return new FileNotFoundException(String.format("'%s' in ResourcePack '%s'", path, this.resourcePackName));
    }

    protected void addBytes(class_2960 id, byte[] bytes) {
        this.namespaces.add(id.method_12836());
        this.resources.put(id, Preconditions.checkNotNull(bytes));
        this.searchTrie.insert(id);
        if (addToStatic) markNotClearable(id);
        //debug
        if (generateDebugResources) {
            saveBytes(id, bytes);
        }
    }

    public static void saveJson(class_2960 id, JsonElement json) {
        try {
            saveBytes(id, RPUtils.serializeJson(json).getBytes());
        } catch (IOException e) {
            LOGGER.error("Failed to deserialize JSON {}", json, e);
        }
    }

    public static void saveBytes(class_2960 id, byte[] bytes) {
        try {
            Path p = Paths.get("debug", "generated_resource_pack").resolve(id.method_12836() + "/" + id.method_12832());
            Files.createDirectories(p.getParent());
            Files.write(p, bytes, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        } catch (IOException ignored) {
        }
    }

    @Deprecated(forRemoval = true)
    public void removeResource(class_2960 res) {
        synchronized (this) {
            this.searchTrie.remove(res);
            this.resources.remove(res);
            this.staticResources.remove(res);
        }
    }

    @Deprecated(forRemoval = true)
    public void addResource(StaticResource resource) {
        this.addBytes(resource.location, resource.data);
    }

    @Deprecated(forRemoval = true)
    private void addJson(class_2960 path, JsonElement json) {
        try {
            this.addBytes(path, RPUtils.serializeJson(json).getBytes());
        } catch (IOException e) {
            LOGGER.error("Failed to write JSON {} to resource pack {}.", path, this.resourcePackName, e);
        }
    }

    @Deprecated(forRemoval = true)
    public void addJson(class_2960 location, JsonElement json, ResType resType) {
        this.addJson(resType.getPath(location), json);
    }

    @Deprecated(forRemoval = true)
    public void addBytes(class_2960 location, byte[] bytes, ResType resType) {
        this.addBytes(resType.getPath(location), bytes);
    }


    public class_3264 getPackType() {
        return packType;
    }

    // Called after texture have been stitched. Only keeps needed stuff
    @ApiStatus.Internal
    protected void clearNonStatic() {
        if (!CommonConfigs.CLEAR_RESOURCES.get()) return;
        if (this.needsClearingNonStatic) {
            this.needsClearingNonStatic = false;
            boolean mf = MODERN_FIX && getPackType() == class_3264.field_14188;
            // clear trie entirely and re populate as we always expect to have way less staitc resources than others
            if (!mf) this.searchTrie.clear();

            for (var r : this.resources.keySet()) {
                if (mf && modernFixHack(r.method_12832())) {
                    continue;
                }
                if (!this.staticResources.contains(r)) {
                    this.resources.remove(r);
                }
            }


            if (mf) {
                List<String> toRemove = new ArrayList<>();
                for (String namespace : this.searchTrie.listFolders("")) {
                    for (String f : this.searchTrie.listFolders(namespace)) {
                        if (!modernFixHack(f)) {
                            toRemove.add(namespace + "/" + f);
                        }
                    }
                }
                toRemove.forEach(this.searchTrie::remove);
            }
            // rebuild search trie with just static
            for (var s : staticResources) {
                this.searchTrie.insert(s);
            }
        }
    }

    // Called after each reload
    @ApiStatus.Internal
    protected void clearAllContent() {
        synchronized (this) {
            this.searchTrie.clear();
            this.resources.clear();
            this.needsClearingNonStatic = true; //clear non static after dynamic textures have been stitched
        }
    }


    private static final boolean MODERN_FIX = CompatHandler.MODERNFIX && ModernFixCompat.areLazyResourcesOn();

    private boolean modernFixHack(String s) {
        return s.startsWith("model") || s.startsWith("blockstate");
    }

    public void addTag(SimpleTagBuilder tag, class_5321<?> key) {
    }

    protected static class ResourceLocPathTrie extends PathTrie<class_2960> {

        public boolean remove(class_2960 object) {
            //remove last bit as that's the object
            String path = object.method_12836() + '/' + object.method_12832().substring
                    (0, object.method_12832().lastIndexOf('/'));
            return super.remove(path);
        }

        public void insert(class_2960 object) {
            String path = object.method_12836() + '/' + object.method_12832().substring
                    (0, object.method_12832().lastIndexOf('/'));
            super.insert(path, object);
        }

    }
}