package net.mehvahdjukaar.moonlight.api.resources.recipe.fabric;

import ;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.mehvahdjukaar.moonlight.api.resources.recipe.BlockTypeSwapIngredient;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.set.BlockSetInternal;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BlockTypeSwapIngredientImpl<T extends BlockType> implements CustomIngredient, BlockTypeSwapIngredient {

    private static final class_2960 ID = Moonlight.res("block_type_swap");

    private final class_1856 inner;
    private final T fromType;
    private final T toType;
    private final BlockTypeRegistry<T> registry;

    private List<class_1799> items;

    public BlockTypeSwapIngredientImpl(class_1856 inner, T fromType, T toType, BlockTypeRegistry<T> reg) {
        super();
        Preconditions.checkNotNull(fromType, "From block type cannot be null");
        Preconditions.checkNotNull(toType, "To block type cannot be null");
        this.inner = inner;
        this.fromType = fromType;
        this.toType = toType;
        this.registry = reg;
    }


    @Override
    public class_1856 getInner() {
        return inner;
    }

    @Override
    public boolean test(class_1799 stack) {
        if (stack != null) {
            for (class_1799 itemStack : this.getMatchingStacks()) {
                if (itemStack.method_31574(stack.method_7909())) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public List<class_1799> convertItems(List<class_1799> toConvert) {
        List<class_1799> newItems = new ArrayList<>();
        boolean success = false;
        for (class_1799 it : toConvert) {
            var type = this.registry.getBlockTypeOf(it.method_7909());
            if (type != this.fromType) {
                break;
            } else {
                var newItem = BlockType.changeItemType(it.method_7909(), this.fromType, this.toType);
                if (newItem != null) {
                    newItems.add(new class_1799(newItem));
                    success = true;
                }
            }
        }
        if (!success) {
            newItems.addAll(toConvert);
        }
        return newItems;
    }

    @Override
    public List<class_1799> getMatchingStacks() {
        if (this.items == null) {
            var original = this.inner.method_8105();
            this.items = convertItems(Arrays.asList(original));
        }
        return this.items;
    }

    @Override
    public boolean requiresTesting() {
        return inner.requiresTesting();
    }

    @Override
    public CustomIngredientSerializer<BlockTypeSwapIngredientImpl<?>> getSerializer() {
        return SERIALIZER;
    }

    public static CustomIngredientSerializer<BlockTypeSwapIngredientImpl<?>> SERIALIZER =
            new CustomIngredientSerializer<>() {
                @Override
                public class_2960 getIdentifier() {
                    return ID;
                }

                @Override
                public BlockTypeSwapIngredientImpl<?> read(JsonObject json) {
                    var reg = BlockSetInternal.getRegistry(json.get("block_type").getAsString());
                    var from = reg.getFromNBT(json.get("from").getAsString());
                    var to = reg.getFromNBT(json.get("to").getAsString());
                    var ing = class_1856.method_52177(json.get("ingredient"));
                    return new BlockTypeSwapIngredientImpl<>(ing, from, to, (BlockTypeRegistry) reg);
                }

                @Override
                public void write(JsonObject json, BlockTypeSwapIngredientImpl<?> ingredient) {
                    json.addProperty("block_type", ingredient.registry.typeName());
                    json.addProperty("from", ingredient.fromType.getId().toString());
                    json.addProperty("to", ingredient.toType.getId().toString());
                    json.add("ingredient", ingredient.inner.method_8089());
                }

                @Override
                public BlockTypeSwapIngredientImpl<?> read(class_2540 buf) {
                    var reg = BlockSetInternal.getRegistry(buf.method_19772());
                    var from = reg.getFromNBT(buf.method_19772());
                    var to = reg.getFromNBT(buf.method_19772());
                    var ing = class_1856.method_8086(buf);
                    return new BlockTypeSwapIngredientImpl<>(ing, from, to, (BlockTypeRegistry) reg);
                }

                @Override
                public void write(class_2540 buf, BlockTypeSwapIngredientImpl<?> ing) {
                    buf.method_10814(ing.registry.typeName());
                    buf.method_10814(ing.fromType.getId().toString());
                    buf.method_10814(ing.toType.getId().toString());
                    ing.inner.method_8088(buf);
                }
            };

    public static <T extends BlockType> class_1856 create(class_1856 original, T from, T to) {

        return new BlockTypeSwapIngredientImpl<>(original, from, to, from.getRegistry())
                .toVanilla();
    }

    public static void init() {
        CustomIngredientSerializer.register(SERIALIZER);
    }
}
