package net.mehvahdjukaar.moonlight.api.set;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.util.INamedSupplier;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.set.BlockSetInternal;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public abstract class BlockType {

    //stuff made out of this type
    private final BiMap<String, Object> children = HashBiMap.create();
    public final class_2960 id;

    protected BlockType(class_2960 resourceLocation) {
        this.id = resourceLocation;
    }

    public class_2960 getId() {
        return id;
    }

    public String getTypeName() {
        String path = id.method_12832();
        if (path.contains("/")) {
            return path.substring(path.lastIndexOf("/") + 1);
        }
        return path;
    }

    public String getNamespace() {
        return id.method_12836();
    }

    /**
     * @return namespace/TYPENAME
     */
    public String getAppendableId() {
        return this.getNamespace() + "/" + this.getTypeName();
    }

    /**
     * @return namespace/TYPENAME_suffix
     */
    public String getAppendableIdWith(String suffix) {
        return getAppendableIdWith("", suffix);
    }

    /**
     * @return namespace/prefix_TYPENAME_suffix
     */
    public String getAppendableIdWith(String prefix, String suffix) {
        String prefixed = (prefix.isEmpty()) ? "" : prefix + "_";
        return this.getNamespace() + "/" + prefixed + this.getTypeName() + "_" + suffix;
    }

    /**
     * @return shortenedID/namespace/TYPENAME_suffix
     */
    public String createPathWith(String shortenedId, String suffix) {
        return createFullIdWith("", "", shortenedId, "", suffix);
    }

    /**
     * @return shortenedID/namespace/prefix_TYPENAME_suffix
     */
    public String createPathWith(String shortenedId, String prefix, String suffix) {
        return createFullIdWith("", "", shortenedId, prefix, suffix);
    }

    /**
     * @return namespace:folder/shortenedID/namespace/prefix_TYPENAME_suffix
     * OPTIONAL: modId, folder, prefix can be empty
     */
    public String createFullIdWith(String modIdOrEmpty, String folderOrEmpty, String shortenedIdOrEmpty, String prefixOrEmpty, String suffix) {
        String modIded = (modIdOrEmpty.isEmpty()) ? "" : modIdOrEmpty + ":";
        String foldered = (folderOrEmpty.isEmpty()) ? "" : folderOrEmpty + "/";
        String namespaced = (modIdOrEmpty.equals(this.getNamespace())) ? "" : this.getNamespace() + "/";
        String shortenedId = (shortenedIdOrEmpty.isEmpty()) ? "" : shortenedIdOrEmpty + "/";

        String prefixed = "";
        if (prefixOrEmpty.contains("/")) prefixed = prefixOrEmpty;
        else if (!prefixOrEmpty.isEmpty()) prefixed = prefixOrEmpty + "_";

        String suffixed = "";
        if (suffix.matches("\\.(png|json)")) suffixed = suffix;
        else if (!suffix.isEmpty()) suffixed = "_" + suffix;

        return modIded + foldered + shortenedId + namespaced + prefixed + this.getTypeName() + suffixed;
    }

    @Override
    public String toString() {
        return this.id.toString();
    }

    public abstract String getTranslationKey();

    /**
     * Use this to get the new id of a block variant
     * NOTE: minecraft will be ignored as namespace
     * TYPENAME == getTypeName()
     *
     * @param baseName base variant name
     * @return baseName_TYPENAME OR namespace/baseName_TYPENAME
     */
    public String getVariantId(String baseName) {
        String namespace = this.isVanilla() ? "" : this.getNamespace() + "/";
        if (baseName.contains("%s")) return namespace + String.format(baseName, this.getTypeName());
        else return namespace + baseName + "_" + this.getTypeName();
    }

    /**
     * NOTE: minecraft will be ignored as namespace
     *
     * @return prefix_baseName_TYPENAME OR namespace/prefix_baseName_TYPENAME
     */
    public String getVariantId(String baseName, boolean prefix) {
        return getVariantId(prefix ? baseName + "_%s" : "%s_" + baseName);
    }

    /**
     * NOTE: minecraft will be ignored as namespace
     *
     * @return prefix_TYPENAME_postfix OR namespace/prefix_TYPENAME_postfix
     */
    public String getVariantId(String postfix, String prefix) {
        return getVariantId(prefix + "_%s_" + postfix);
    }

    public String getReadableName() {
        return LangBuilder.getReadableName(this.getTypeName());
    }

    public boolean isVanilla() {
        return this.getNamespace().equals("minecraft");
    }

    @SuppressWarnings("unchecked")
    public <T extends BlockType> BlockTypeRegistry<T> getRegistry() {
        return (BlockTypeRegistry<T>) BlockSetInternal.getRegistry(this.getClass());
    }


    @Nullable
    protected <V> V findRelatedEntry(String prefixOrInfix, class_2378<V> reg) {
        return findRelatedEntry(prefixOrInfix, "", reg);
    }

    @Nullable
    @SuppressWarnings("SameParameterValue")
    protected <V> V findRelatedEntry(String prefixOrInfix, String suffix, class_2378<V> reg) {
        String prefixed = (prefixOrInfix.isEmpty()) ? "" : prefixOrInfix + "_";
        String infixed = (prefixOrInfix.isEmpty()) ? "" : "_" + prefixOrInfix;
        String suffixed = (suffix.isEmpty()) ? "" : "_" + suffix;

        class_2960[] targets = {
                new class_2960(id.method_12836(), id.method_12832() + infixed + suffixed),
                new class_2960(id.method_12836(), prefixed + id.method_12832() + suffixed),
        };
        return Utils.findFirstInRegistry(reg, targets);
    }

    /**
     * @return set of objects made out of this block type marked by their generic name
     */
    public Set<Map.Entry<String, Object>> getChildren() {
        return this.children.entrySet();
    }

    /**
     * Gets an item made out of this type
     */
    @Nullable
    public class_1792 getItemOfThis(String key) {
        var v = this.getChild(key);
        class_1792 it = v instanceof class_1935 i ? i.method_8389() : null;
        return it == class_1802.field_8162 ? null : it;
    }

    @Nullable
    public class_2248 getBlockOfThis(String key) {
        var v = this.getChild(key);
        if (v instanceof class_1747 bi) return bi.method_7711();
        return v instanceof class_2248 b ? b : null;
    }

    @Nullable
    public Object getChild(String key) {
        return this.children.get(key);
    }

    /**
     * Should be called after you register a block made out of this wood type
     */
    public void addChild(String genericName, @Nullable Object obj) {
        if (obj == class_1802.field_8162 || obj == class_2246.field_10124) {
            //add better check than this...
            throw new IllegalStateException("Tried to add air block/item to Block Type. Key " + genericName + ". This is a Moonlight bug, please report me");
        }
        if (obj != null) {
            try {
                this.children.put(genericName, obj);
                var registry = BlockSetInternal.getRegistry(this.getClass());
                if (registry != null) {
                    // Don't you dare to access block item map now.
                    // Will cause all sorts of issues. We'll worry about items later
                    registry.mapObjectToType(obj, this);
                }
            } catch (Exception e) {
                Moonlight.LOGGER.error("Failed to add block type child: value already present. Key {}, Object {}, BlockType {}", genericName, obj, this);
            }
        }
    }

    /**
     * Runs right after all blocks registration has run but before any dynamic block registration is run.
     * Use to add existing vanilla or modded blocks
     */
    protected abstract void initializeChildrenBlocks();

    /**
     * Runs right after all items registration has run but before any dynamic block registration is run.
     * Use to add existing vanilla or modded blocks
     */
    protected abstract void initializeChildrenItems();

    /**
     * base block that this type originates from. Has to be an ItemLike
     */
    public abstract class_1935 mainChild();

    /**
     * Returns the given child string key. Null if this type does not have such child
     */
    @Nullable
    public String getChildKey(Object child) {
        return children.inverse().get(child);
    }

    /**
     * Tries changing an item block type. Returns null if it fails
     *
     * @param current        target item
     * @param originalMat    material from which the target item is made of
     * @param destinationMat desired block type
     */
    @Nullable
    public static Object changeType(Object current, @NotNull BlockType originalMat, @NotNull BlockType destinationMat) {
        if (destinationMat == originalMat) return current;
        String key = originalMat.getChildKey(current);
        if (key != null) {
            return destinationMat.getChild(key);
        }
        return null;
    }

    //for items
    @Nullable
    public static class_1792 changeItemType(class_1792 current, @NotNull BlockType originalMat, @NotNull BlockType destinationMat) {
        Object changed = changeType(current, originalMat, destinationMat);
        //if item swap fails, try to swap blocks instead
        if (changed == null) {
            if (current instanceof class_1747 bi) {
                var blockChanged = changeType(bi.method_7711(), originalMat, destinationMat);
                if (blockChanged instanceof class_2248 il) {
                    class_1792 i = il.method_8389();
                    if (i != class_1802.field_8162) changed = i;
                }
            }
        }
        if (changed instanceof class_1935 il) {
            if (il.method_8389() == current) {
                Moonlight.LOGGER.error("Somehow changed an item type into itself. How? Target mat {}, destination map {}, item {}",
                        destinationMat, originalMat, il);
            }
            return il.method_8389();
        }
        return null;
    }

    //for blocks
    @Nullable
    public static class_2248 changeBlockType(@NotNull class_2248 current, BlockType originalMat, BlockType destinationMat) {
        Object changed = changeType(current, originalMat, destinationMat);
        //if block swap fails, try to swap items instead
        if (changed == null) {
            if (current.method_8389() != class_1802.field_8162) {
                var itemChanged = changeType(current.method_8389(), originalMat, destinationMat);
                if (itemChanged instanceof class_1747 bi) {
                    class_1792 i = bi.method_8389();
                    if (i != class_1802.field_8162) changed = i;
                }
            }
        }
        if (changed instanceof class_2248 b) return b;
        return null;
    }

    public class_2498 getSound() {
        if (this.mainChild() instanceof class_2248 b) {
            return b.method_9573(b.method_9564());
        }
        return class_2498.field_11544;
    }


    //TODO: move out of here
    @FunctionalInterface
    public interface SetFinder<T extends BlockType> extends Supplier<Optional<T>> {
        Optional<T> get();
    }

    public abstract static class SetFinderBuilder<T extends BlockType> implements SetFinder<T> {

        protected final class_2960 id;
        protected final Map<String, Supplier<class_1935>> childNames = new HashMap<>();
        private final BlockTypeRegistry<T> reg; //TODO:remove this and place this class in registry class

        public SetFinderBuilder(class_2960 id, BlockTypeRegistry<T> reg) {
            this.id = id;
            this.reg = reg;
        }

        public SetFinderBuilder<T> child(String childType, Supplier<class_1935> child) {
            this.childNames.put(childType, child);
            return this;
        }

        public SetFinderBuilder<T> childItem(String childType, class_2960 childName) {
            return this.child(childType, () -> class_7923.field_41178.method_17966(childName).orElseThrow());
        }

        /**
         * @param prefix include the underscore, "_" if the blockId has one
         * @param suffix include the underscore, "_" if the blockId has one
         */
        public SetFinderBuilder<T> childItemAffix(String childType, String prefix, String suffix) {
            return this.childItem(childType, prefix + id.method_12832() + suffix);
        }

        /**
         * @param suffix include the underscore, "_" if the blockId has one
         */
        public SetFinderBuilder<T> childItemSuffix(String childType, String suffix) {
            return this.childItem(childType, id.method_12832() + suffix);
        }

        public SetFinderBuilder<T> childItem(String childType, String childName) {
            return this.childItem(childType,
                    Utils.idWithOptionalNamespace(childName, id.method_12836()));
        }

        public SetFinderBuilder<T> childBlock(String childType, class_2960 childName) {
            return this.child(childType, () -> class_7923.field_41175.method_17966(childName).orElseThrow());
        }

        /**
         * @param prefix include the underscore, "_" if the blockId has one
         * @param suffix include the underscore, "_" if the blockId has one
         */
        public SetFinderBuilder<T> childBlockAffix(String childType, String prefix, String suffix) {
            return this.childBlock(childType, prefix + id.method_12832() + suffix);
        }

        /**
         * @param suffix include the underscore, "_" if the blockId has one
         */
        public SetFinderBuilder<T> childBlockSuffix(String childType, String suffix) {
            return this.childBlock(childType, id.method_12832() + suffix);
        }

        public SetFinderBuilder<T> childBlock(String childType, String childName) {
            return this.childBlock(childType,
                    Utils.idWithOptionalNamespace(childName, id.method_12836()));
        }

        // returns a supplier of the found block
        public INamedSupplier<T> build() {
            return reg.makeFutureHolder(id);
        }
    }
}
