package net.mehvahdjukaar.moonlight.api.util;

import com.mojang.authlib.GameProfile;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.fake_player.FPClientAccess;
import net.mehvahdjukaar.moonlight.core.fake_player.FakeGenericPlayer;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import org.jetbrains.annotations.ApiStatus;

import java.util.UUID;

public class FakePlayerManager {

    private static final GameProfile DEFAULT = new GameProfile(UUID.fromString(
            "61e22C44-14d5-1f22-ed27-13D2C95CA355"),
            "[ML_Fake_Player]");

    public static class_1657 get(GameProfile id, class_1297 entity) {
        return get(id, entity.method_37908());
    }

    public static class_1657 get(GameProfile id, class_1937 level) {
        class_1657 fakePlayer;
        if (level instanceof class_3218 sl) {
            fakePlayer = PlatHelper.getFakeServerPlayer(id, sl);
        }
        else if (PlatHelper.getPhysicalSide().isServer()) { //on server side but level not serve sided or not instance of server level
            fakePlayer = FakeGenericPlayer.get(level, id);
        } else {
            //class loading hacks
            fakePlayer = FPClientAccess.get(level, id);
        }
        return fakePlayer;
    }

    public static class_1657 get(GameProfile id, class_1297 copyPosFrom, class_1297 copyRotFrom) {
        class_1657 p = get(id, copyPosFrom.method_37908());
        p.method_5814(copyPosFrom.method_23317(), copyPosFrom.method_23318(), copyPosFrom.method_23321());
        p.method_5847(copyRotFrom.method_5791());
        p.method_36457(copyRotFrom.method_36455());
        p.method_36456(copyRotFrom.method_36454());
        p.method_22862();
        return p;
    }

    public static class_1657 getDefault(class_1297 copyPosFrom, class_1297 copyRotFrom) {
        return get(DEFAULT, copyPosFrom, copyRotFrom);
    }

    public static class_1657 getDefault(class_1937 level) {
        return get(DEFAULT, level);
    }

    public static class_1657 getDefault(class_1297 entity) {
        return get(DEFAULT, entity);
    }
}
