package net.mehvahdjukaar.moonlight.core.fluid;

import dev.architectury.injectables.annotations.ExpectPlatform;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidColors;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.network.ClientBoundFinalizeFluidsMessage;
import net.mehvahdjukaar.moonlight.core.network.ModMessages;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_3222;
import net.minecraft.class_3611;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6880.class_6883;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.WeakHashMap;

import static net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry.getHolders;

@ApiStatus.Internal
public class SoftFluidInternal {

    private static final WeakHashMap<class_5455, Map<class_3611, class_6880<SoftFluid>>> FLUID_MAP = new WeakHashMap<>();
    private static final WeakHashMap<class_5455, Map<class_1792, class_6880<SoftFluid>>> ITEM_MAP = new WeakHashMap<>();


    public static class_6880<SoftFluid> fromVanillaFluid(class_3611 fluid, class_5455 registryAccess) {
        if (!FLUID_MAP.containsKey(registryAccess)) {
            populateSlaveMaps(registryAccess);
        }
        return FLUID_MAP.get(registryAccess).get(fluid);
    }

    public static class_6880<SoftFluid> fromVanillaItem(class_1792 item, class_5455 registryAccess) {
        if (!ITEM_MAP.containsKey(registryAccess)) {
            populateSlaveMaps(registryAccess);
        }
        return ITEM_MAP.get(registryAccess).get(item);
    }

    //needs to be called on both sides
    private static void populateSlaveMaps(class_5455 registryAccess) {
        var fluidMap = FLUID_MAP.computeIfAbsent(registryAccess, k -> new IdentityHashMap<>());
        var itemMap = ITEM_MAP.computeIfAbsent(registryAccess, k -> new IdentityHashMap<>());
        fluidMap.clear();
        itemMap.clear();
        for (var h : getHolders()) {
            var s = h.comp_349();
            if (s.isEnabled()) {
                s.getEquivalentFluids().forEach(f -> fluidMap.put(f, h));
                s.getContainerList().getPossibleFilled().forEach(i -> {
                    //don't associate water to potion bottle
                    if (i != class_1802.field_8574 || !BuiltInSoftFluids.WATER.is(h)) {
                        itemMap.put(i, h);
                    }
                });
            }
        }
    }


    @ExpectPlatform
    public static void init() {
    }

    //wtf is going on here

    //called by data sync to player
    public static void postInitClient() {
        FLUID_MAP.clear();
        ITEM_MAP.clear();
        //ok so here the extra registered fluids should have already been sent to the client
        SoftFluidColors.refreshParticleColors(Utils.hackyGetRegistryAccess());
    }

    public static void onDataSyncToPlayer(class_3222 player, boolean isJoined) {
        //just sends on login
        if (isJoined) {
            ModMessages.CHANNEL.sendToClientPlayer(player, new ClientBoundFinalizeFluidsMessage());
        }
    }

    //on data load
    public static void doPostInitServer(class_5455 reg) {
        populateSlaveMaps(reg);
        //registers existing fluids. also update the salve maps
        //we need to call this on bont server and client as this happens too late and these wont be sent
        registerExistingVanillaFluids(FLUID_MAP.get(reg), ITEM_MAP.get(reg));
    }

    @ExpectPlatform
    private static void registerExistingVanillaFluids(Map<class_3611, class_6880<SoftFluid>> fluidMap, Map<class_1792, class_6880<SoftFluid>> itemMap) {
        throw new AssertionError();
    }


}

