package net.mehvahdjukaar.moonlight.core.fluid.fabric;

import net.fabricmc.fabric.api.event.registry.DynamicRegistries;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.mixins.fabric.MappedRegistryAccessor;
import net.minecraft.class_1792;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import java.util.Map;

public class SoftFluidInternalImpl {

    public static void init() {
        DynamicRegistries.registerSynced(SoftFluidRegistry.KEY, SoftFluid.CODEC, SoftFluid.CODEC, DynamicRegistries.SyncOption.SKIP_WHEN_EMPTY);
    }

    public static void registerExistingVanillaFluids(Map<class_3611, class_6880<SoftFluid>> fluidMap, Map<class_1792, class_6880<SoftFluid>> itemMap) {
        //only runs on the first object
        class_2370<SoftFluid> reg = (class_2370<SoftFluid>) SoftFluidRegistry.hackyGetRegistry();
        ((MappedRegistryAccessor) reg).setFrozen(false);
        for (class_3611 f : class_7923.field_41173) {
            try {
                if (f == null) continue;
                if (f instanceof class_3609 flowingFluid && flowingFluid.method_15751() != f) continue;
                if (f == class_3612.field_15906) continue;
                //if fluid map contains fluid it means that another equivalent fluid has already been registered
                if (fluidMap.containsKey(f)) continue;
                //is not equivalent: create new SoftFluid from forge fluid

                SoftFluid sf = (new SoftFluid.Builder(f)).build();
                //calling vanilla register function because calling that deferred register or forge registry now does nothing
                //cope
                //SOFT_FLUIDS.get().register(sf.getRegistryName(),sf);
                class_2378.method_10230(reg, Utils.getID(f), sf);
                fluidMap.put(f, reg.method_40265(reg.method_10206(sf)).orElseThrow());

            } catch (Exception ignored) {
            }
        }
        //adds empty fluid
        //Registry.register(reg, Moonlight.res("empty"), SoftFluidRegistry.EMPTY);
        reg.method_40276();
    }

}
