package net.mehvahdjukaar.moonlight.core.misc;

import ;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1079;
import net.minecraft.class_1080;
import net.minecraft.class_3255;
import net.minecraft.class_3298;
import net.minecraft.class_3518;

//TODO: move out of here
public record McMetaFile(@NotNull class_1079 animation, JsonObject moddedStuff) {

    public static McMetaFile of(@NotNull class_1079 vanillaMcmeta) {
        return new McMetaFile(vanillaMcmeta, new JsonObject());
    }

    public static McMetaFile of(@NotNull class_1079 vanillaMcmeta, JsonObject moddedStuff) {
        return new McMetaFile(vanillaMcmeta, moddedStuff);
    }

    public static McMetaFile read(class_3298 resource) throws IOException {
        try (InputStream metadataStream = resource.method_14482()) {
            var bytes = metadataStream.readAllBytes();
            class_1079 metadata = class_3255.method_14392(class_1079.field_5337, new ByteArrayInputStream(bytes));
            if (metadata == null) {
                metadata = class_1079.field_21768;
            }
            JsonObject moddedObj = readModdedObj(bytes);
            return of(metadata, moddedObj);
        }
    }

    private static JsonObject readModdedObj(byte[] bytes) {
        // read json from bytes
        JsonObject jo = class_3518.method_15285(new String(bytes));
        // remove vanilla fields
        for (String key : new String[]{"frametime", "width", "height", "interpolate", "frames"}) {
            jo.remove(key);
        }
        return jo;
    }

    /**
     *  Furniture, Decoratives are the "mostImportant"<br>
     *  BlockTypes are the "leastImportant"
     **/
    public static @Nullable McMetaFile merge(@Nullable McMetaFile mostImportant, @Nullable McMetaFile leastImportant) {
        if (mostImportant == null && leastImportant == null) return null;
        if (leastImportant == null) return mostImportant;
        if (mostImportant == null) return leastImportant;
        if (mostImportant.animation == class_1079.field_21768) {
            return of(leastImportant.animation, mostImportant.moddedStuff);
        }
        return mostImportant;
    }

    public JsonObject toJson() {
        JsonObject obj = moddedStuff.deepCopy();

        JsonObject animObj = new JsonObject();

        animObj.addProperty("frametime", animation.method_4684());
        animObj.addProperty("interpolate", animation.method_4685());
        animObj.addProperty("height", animation.field_5336);
        animObj.addProperty("width", animation.field_5338);

        JsonArray frames = new JsonArray();

        animation.method_33460((i, t) -> {
            if (t != -1) {
                JsonObject o = new JsonObject();
                o.addProperty("time", t);
                o.addProperty("index", i);
                frames.add(o);
            } else frames.add(i);
        });

        animObj.add("frames", frames);

        obj.add("animation", animObj);

        return obj;
    }

    public McMetaFile cloneWithSize(int frameWidth, int frameHeight) {
        List<class_1080> frameData = new ArrayList<>();
        this.animation.method_33460((i, t) -> frameData.add(new class_1080(i, t)));
        class_1079 newMetadata = new class_1079(frameData, frameWidth, frameHeight,
                this.animation.method_4684(), this.animation.method_4685());
        JsonObject newModdedStuff = moddedStuff.deepCopy();
        return new McMetaFile(newMetadata, newModdedStuff);
    }

    private static List<Field> FIELDS = null;
    private static final int VANILLA_FIELDS = 5;

    public static void copyAllMixinAddedFields(class_1079 from, class_1079 to) {
        if (FIELDS == null) {
            FIELDS = new ArrayList<>();
            Field[] f = class_1079.class.getDeclaredFields();
            for (int i = 0; i < f.length; i++) {
                if (i > VANILLA_FIELDS - 1) {
                    Field field = f[i];
                    FIELDS.add(field);
                    field.setAccessible(true);
                }
            }
        }
        for (Field field : FIELDS) {
            try {
                field.set(to, field.get(from));
            } catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public int getLogicalFrameCount() {
        return Math.max(1, animation().field_5339.size());
    }

    public boolean hasEmptyAnimation() {
        return this.animation == class_1079.field_21768 || this.animation.field_5339.isEmpty();
    }
}
