package net.mehvahdjukaar.moonlight.core.mixins;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.mehvahdjukaar.moonlight.core.ClientConfigs;
import net.mehvahdjukaar.moonlight.core.misc.IMapDataPacketExtension;
import net.minecraft.class_22;
import net.minecraft.class_2487;
import net.minecraft.class_2683;
import net.minecraft.class_330;
import net.minecraft.class_634;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_634.class)
public abstract class ClientPacketListenerMixin {

    @WrapOperation(method = {"handleMapItemData", "handleMapItemDataOld"}, // handleMapItemDataOld from NetEase MC 1.20.1
            at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/MapRenderer;update(ILnet/minecraft/world/level/saveddata/maps/MapItemSavedData;)V"))
    private void ml$handleExtraData(class_330 instance, int mapId, class_22 mapData, Operation<Void> operation,
                                 @Local(argsOnly = true) class_2683 packet) {
        IMapDataPacketExtension ext = (IMapDataPacketExtension) packet;
        class_2487 customServerData = ext.moonlight$getCustomMapDataTag();
        boolean updateTexture = ext.moonlight$getColorPatch() != null;
        if (customServerData != null) {
            updateTexture = true;
        }
        updateTexture = updateTexture || !ClientConfigs.LAZY_MAP_DATA.get();
        //suppress un needed map rendered texture uploads
        if (updateTexture) {
            operation.call(instance, mapId, mapData);
        }
    }
}
