package net.mehvahdjukaar.moonlight.core.mixins;

import net.mehvahdjukaar.moonlight.api.events.IDropItemOnDeathEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import java.util.Iterator;
import java.util.List;

@Mixin(class_1661.class)
public abstract class InventoryMixin {

    @Shadow @Final public class_1657 player;

    @Unique
    private class_1799 moonlight$toRestore = null;


    @Inject(method = "dropAll", at = @At(value = "INVOKE", target = "Ljava/util/List;get(I)Ljava/lang/Object;",
            shift = At.Shift.BEFORE), locals = LocalCapture.CAPTURE_FAILHARD)
    public void fireDropEvent(CallbackInfo ci, Iterator var1, List<class_1799> list, int i) {
        if(this.player.method_29504() || this.player.field_6272){
            class_1799 stack = list.get(i);
            IDropItemOnDeathEvent event = IDropItemOnDeathEvent.create(stack, player, true);
            MoonlightEventsHelper.postEvent( event, IDropItemOnDeathEvent.class);
            if(event.isCanceled()){
                list.set(i, class_1799.field_8037);
                moonlight$toRestore = event.getReturnItemStack();
            }
        }
    }

    @Inject(method = "dropAll", at = @At(value = "INVOKE", target = "Ljava/util/List;get(I)Ljava/lang/Object;",
            shift = At.Shift.AFTER), locals = LocalCapture.CAPTURE_FAILHARD)
    public void restoreNotDropped(CallbackInfo ci, Iterator var1, List<class_1799> list, int i) {
        if(moonlight$toRestore != null){
            list.set(i, moonlight$toRestore);
            moonlight$toRestore = null;
        }
    }
}