package net.mehvahdjukaar.moonlight.core.mixins;

import com.google.common.collect.Maps;
import net.mehvahdjukaar.moonlight.api.map.CustomMapData;
import net.mehvahdjukaar.moonlight.api.map.CustomMapData.Type;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.mehvahdjukaar.moonlight.core.misc.IHoldingPlayerExtension;
import net.minecraft.class_1657;
import net.minecraft.class_17;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.*;
import java.util.Map.Entry;
import java.util.function.Consumer;


@Mixin(class_22.class)
public abstract class MapDataMixin extends class_18 implements ExpandedMapData {

    @Final
    @Shadow
    public byte scale;

    @Final
    @Shadow
    Map<String, net.minecraft.class_20> decorations;

    @Shadow
    @Final
    private Map<String, class_17> bannerMarkers;

    @Shadow
    public int centerX;
    @Shadow
    public int centerZ;

    @Shadow
    @Final
    private List<class_22.class_23> carriedBy;
    //new decorations (stuff that gets rendered)
    @Unique
    public Map<String, CustomMapDecoration> moonlight$customDecorations = Maps.newLinkedHashMap();

    //world markers (stuff that gets saved)
    @Unique
    private final Map<String, MapBlockMarker<?>> moonlight$customMapMarkers = Maps.newHashMap();

    //custom data that can be stored in maps
    @Unique
    public final Map<class_2960, CustomMapData<?>> moonlight$customData = new LinkedHashMap<>();

    @Override
    public void setCustomDecorationsDirty() {
        this.method_80();
        carriedBy.forEach(h -> ((IHoldingPlayerExtension) h).moonlight$setCustomMarkersDirty());
    }

    @Override
    public <H extends CustomMapData.DirtyCounter> void setCustomDataDirty(
            CustomMapData.Type<?> type, Consumer<H> dirtySetter) {
        this.method_80();
        carriedBy.forEach(h -> ((IHoldingPlayerExtension) h)
                .moonlight$setCustomDataDirty(type, dirtySetter));

    }

    @Override
    public Map<class_2960, CustomMapData<?>> getCustomData() {
        return moonlight$customData;
    }

    @Override
    public Map<String, CustomMapDecoration> getCustomDecorations() {
        return moonlight$customDecorations;
    }

    @Override
    public Map<String, MapBlockMarker<?>> getCustomMarkers() {
        return moonlight$customMapMarkers;
    }

    @Override
    public int getVanillaDecorationSize() {
        return this.decorations.size();
    }

    @Override
    public <M extends MapBlockMarker<?>> void addCustomMarker(M marker) {
        var decoration = marker.createDecorationFromMarker((class_22) (Object)this);
        if (decoration != null) {
            this.moonlight$customDecorations.put(marker.getMarkerId(), decoration);
            if(marker.shouldSave()) {
                this.moonlight$customMapMarkers.put(marker.getMarkerId(), marker);
            }
            //so packet is sent
            setCustomDecorationsDirty();
        }
    }

    @Override
    public boolean removeCustomMarker(String key){
        moonlight$customDecorations.remove(key);
        if(moonlight$customMapMarkers.containsKey(key)){
            moonlight$customMapMarkers.remove(key);
            setCustomDecorationsDirty();
            return true;
        }
        return false;
    }

    @Override
    public class_22 copy() {
        class_22 newData = class_22.method_32371(this.method_75(new class_2487()));
        newData.method_80();
        return newData;
    }

    @Override
    public void resetCustomDecoration() {
        if (!bannerMarkers.isEmpty() || !moonlight$customMapMarkers.isEmpty()) {
            setCustomDecorationsDirty();
        }
        for (String key : this.moonlight$customMapMarkers.keySet()) {
            this.moonlight$customDecorations.remove(key);
        }
        this.moonlight$customMapMarkers.clear();
        for (String key : this.bannerMarkers.keySet()) {
            this.decorations.remove(key);
        }
        this.bannerMarkers.clear();
    }

    /**
     * @param world level
     * @param pos   world position where a marker providing block could be
     * @return true if a marker was toggled
     */
    @Override
    public boolean toggleCustomDecoration(class_1936 world, class_2338 pos) {
        if (world.method_8608()) {
            List<MapBlockMarker<?>> markers = MapDataInternal.getMarkersFromWorld(world, pos);
            return !markers.isEmpty();
        }

        double d0 = pos.method_10263() + 0.5D;
        double d1 = pos.method_10260() + 0.5D;
        int i = 1 << this.scale;
        double d2 = (d0 - this.centerX) / i;
        double d3 = (d1 - this.centerZ) / i;
        if (d2 >= -63.0D && d3 >= -63.0D && d2 <= 63.0D && d3 <= 63.0D) {
            List<MapBlockMarker<?>> markers = MapDataInternal.getMarkersFromWorld(world, pos);

            boolean changed = false;
            for (MapBlockMarker<?> marker : markers) {
                if (marker != null) {
                    //toggle
                    String id = marker.getMarkerId();
                    if (marker.equals(this.moonlight$customMapMarkers.get(id))) {
                        removeCustomMarker(id);
                    } else {
                        this.addCustomMarker(marker);
                    }
                    changed = true;
                }
            }
            return changed;
        }
        return false;
    }


    @Inject(method = "locked", at = @At("RETURN"))
    public void locked(CallbackInfoReturnable<class_22> cir) {
        class_22 data = cir.getReturnValue();
        if (data instanceof ExpandedMapData expandedMapData) {
            expandedMapData.getCustomMarkers().putAll(this.getCustomMarkers());
            expandedMapData.getCustomDecorations().putAll(this.getCustomDecorations());
        }
        moonlight$copyCustomData(data, false);
    }

    @Inject(method = "scaled", at = @At("RETURN"))
    public void scaled(CallbackInfoReturnable<class_22> cir) {
        class_22 data = cir.getReturnValue();
        moonlight$copyCustomData(data, true);
    }

    @Unique
    private void moonlight$copyCustomData(class_22 data, boolean isScaled) {
        if (data instanceof ExpandedMapData ed) {
            for (var entry : this.moonlight$customData.entrySet()) {
                var customData = entry.getValue();
                boolean persists = isScaled ? customData.persistOnRescale() : customData.persistOnCopyOrLock();
                if (persists) {
                    class_2487 t = new class_2487();
                    customData.save(t);
                    ed.getCustomData().get(entry.getKey()).load(t);
                }
            }
        }
    }


    @Inject(method = "tickCarriedBy", at = @At("TAIL"))
    public void tickCarriedBy(class_1657 player, class_1799 stack, CallbackInfo ci) {
        class_2487 tag = stack.method_7969();
        if (tag != null) {
            if (tag.method_10573("CustomDecorations", 9)) {
                class_2499 listTag = tag.method_10554("CustomDecorations", 10);
                //for exploration maps
                for (int j = 0; j < listTag.size(); ++j) {
                    class_2487 com = listTag.method_10602(j);
                    if (!this.decorations.containsKey(com.method_10558("id"))) {
                        String name = com.method_10558("type");

                        MapDecorationType<? extends CustomMapDecoration, ?> type = MapDataInternal.get(name);
                        if (type != null) {
                            class_2338 pos = new class_2338(com.method_10550("x"), 64, com.method_10550("z"));
                            MapBlockMarker<?> marker = type.createEmptyMarker();
                            marker.setPos(pos);
                            this.addCustomMarker(marker);
                        } else {
                            Moonlight.LOGGER.warn("Failed to load map decoration " + name + ". Skipping it");
                        }
                    }
                }
            }
        }
    }

    @Inject(method = "load", at = @At("RETURN"))
    private static void load(class_2487 compound, CallbackInfoReturnable<class_22> cir) {
        class_22 data = cir.getReturnValue();
        if (compound.method_10545("customMarkers") && data instanceof ExpandedMapData mapData) {
            class_2499 listNBT = compound.method_10554("customMarkers", 10);

            for (int j = 0; j < listNBT.size(); ++j) {
                MapBlockMarker<?> marker = MapDataInternal.readWorldMarker(listNBT.method_10602(j));
                if (marker != null) {
                    mapData.getCustomMarkers().put(marker.getMarkerId(), marker);
                    mapData.addCustomMarker(marker);
                }
            }
            mapData.getCustomData().values().forEach( customMapData -> customMapData.load(compound));
        }
    }

    @Inject(method = "save", at = @At("RETURN"))
    public void save(class_2487 tag, CallbackInfoReturnable<class_2487> cir) {
        class_2487 com = cir.getReturnValue();

        class_2499 listNBT = new class_2499();

        for (MapBlockMarker<?> marker : this.moonlight$customMapMarkers.values()) {
            if(marker.shouldSave()) {
                class_2487 com2 = new class_2487();
                com2.method_10566(marker.getTypeId(), marker.saveToNBT());
                listNBT.add(com2);
            }
        }
        com.method_10566("customMarkers", listNBT);

        this.moonlight$customData.forEach((s, o) -> o.save(tag));

    }

    @Inject(method = "checkBanners", at = @At("TAIL"))
    public void checkCustomDeco(class_1922 world, int x, int z, CallbackInfo ci) {
        List<String> toRemove = new ArrayList<>();
        List<MapBlockMarker<?>> toAdd = new ArrayList<>();
        for (var e : this.moonlight$customMapMarkers.entrySet()) {
            var marker = e.getValue();
            if (marker.getPos().method_10263() == x && marker.getPos().method_10260() == z) {
                if(marker.shouldRefresh()) {
                    MapBlockMarker<?> newMarker = marker.getType().getWorldMarkerFromWorld(world, marker.getPos());
                    String id = e.getKey();
                    if (newMarker == null) {
                        toRemove.add(id);
                    } else if (!Objects.equals(marker, newMarker)) {
                        toRemove.add(id);
                        toAdd.add(newMarker);
                    }
                }
            }
        }
        toRemove.forEach(this::removeCustomMarker);
        toAdd.forEach(this::addCustomMarker);
    }

    @Inject(method = "<init>", at = @At("TAIL"))
    public void initCustomData(int i, int j, byte b, boolean bl, boolean bl2, boolean bl3, class_5321 resourceKey, CallbackInfo ci) {
        for(var d : MapDataInternal.CUSTOM_MAP_DATA_TYPES.values()){
            moonlight$customData.put(d.id(), d.factory().get());
        }
    }
}
