package net.mehvahdjukaar.moonlight.core.mixins;

import ;
import io.netty.buffer.Unpooled;
import net.mehvahdjukaar.moonlight.api.map.CustomMapData;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.mehvahdjukaar.moonlight.core.misc.IMapDataPacketExtension;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2683;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Collection;
import java.util.Map;

//I hope this won't break with mods. We need this as all data needs to be received at the same time
@Mixin(class_2683.class)
public class MapItemDataPacketMixin implements IMapDataPacketExtension {

    @Shadow
    @Final
    @Nullable
    private class_22.class_5637 colorPatch;
    @Shadow
    @Final
    private int mapId;
    @Unique
    private CustomMapDecoration[] moonlight$customDecorations = null;
    @Unique
    private class_2487 moonlight$customData = null;
    @Unique
    private int moonlight$mapCenterX = 0;
    @Unique
    private int moonlight$mapCenterZ = 0;
    @Unique
    private class_2960 moonlight$dimension = class_1937.field_25179.method_29177();

    //new constructor expansion
    @Inject(method = "<init>(IBZLjava/util/Collection;Lnet/minecraft/world/level/saveddata/maps/MapItemSavedData$MapPatch;)V",
            at = @At("RETURN"))
    private void addExtraCenterAndDimension(int mapId, byte b, boolean bl, Collection collection, class_22.class_5637 mapPatch, CallbackInfo ci) {
        var level = PlatHelper.getCurrentServer().method_3847(class_1937.field_25179);
        if (level != null) {
            class_22 data = Moonlight.getMapDataFromKnownKeys(level, mapId);
            if (data != null) {
                this.moonlight$mapCenterX = data.field_116;
                this.moonlight$mapCenterZ = data.field_115;
                this.moonlight$dimension = data.field_118.method_29177();
            }
        }
    }


    @Inject(method = "<init>(Lnet/minecraft/network/FriendlyByteBuf;)V",
            at = @At("RETURN"))
    private void readExtraData(class_2540 buf, CallbackInfo ci) {
        // we always need to send enough data to create the correct map type because we don't know if client has it
        // again velocity BS
        if (!buf.isReadable()) {
            Moonlight.warnInvalidServer();
            return;
        }

        if (buf.readBoolean()) {
            moonlight$dimension = buf.method_10810();
            moonlight$mapCenterX = buf.method_10816();
            moonlight$mapCenterZ = buf.method_10816();
        }
        if (buf.readBoolean()) {
            this.moonlight$customDecorations = new CustomMapDecoration[buf.method_10816()];
            for (int m = 0; m < moonlight$customDecorations.length; ++m) {
                MapDecorationType<?, ?> type = MapDataInternal.get(buf.method_10810());
                if (type != null) {
                    moonlight$customDecorations[m] = type.loadDecorationFromBuffer(buf);
                }
            }
        }
        if (buf.readBoolean()) {
            //TODO: I really could have merged the 2 systems
            this.moonlight$customData = buf.method_10798(); //readCompressedNbt(buf);
        }
    }

    @Inject(method = "write", at = @At("RETURN"))
    private void writeExtraData(class_2540 buf, CallbackInfo ci) {
        buf.writeBoolean(moonlight$dimension != null);
        if (moonlight$dimension != null) {
            buf.method_10812(moonlight$dimension);
            buf.method_10804(moonlight$mapCenterX);
            buf.method_10804(moonlight$mapCenterZ);
        }

        buf.writeBoolean(moonlight$customDecorations != null);
        if (moonlight$customDecorations != null) {
            buf.method_10804(moonlight$customDecorations.length);

            for (CustomMapDecoration decoration : moonlight$customDecorations) {
                buf.method_10812(Utils.getID(decoration.getType()));
                decoration.saveToBuffer(buf);
            }
        }

        buf.writeBoolean(moonlight$customData != null);
        if (moonlight$customData != null) {
            buf.method_10794(moonlight$customData);
            // writeCompressedNbt(buf, moonlight$customData);
        }
    }

    @Override
    public void moonlight$sendCustomDecorations(Collection<CustomMapDecoration> decorations) {

        //packet will be passed to client no decoding. if we are on an integrated server we need to create new objects
        if (PlatHelper.getPhysicalSide().isClient()) {
            var buffer = new class_2540(Unpooled.buffer());
            decorations = decorations.stream().map(e -> {
                e.saveToBuffer(buffer);
                CustomMapDecoration d = e.getType().loadDecorationFromBuffer(buffer);
                return d;
            }).toList();
        }
        moonlight$customDecorations = decorations.toArray(CustomMapDecoration[]::new);
    }

    @Override
    public void moonlight$sendCustomMapDataTag(class_2487 dataTag) {
        moonlight$customData = dataTag;
    }

    @Override
    public class_2487 moonlight$getCustomMapDataTag() {
        return moonlight$customData;
    }

    @Override
    public class_22.class_5637 moonlight$getColorPatch() {
        return colorPatch;
    }

    @Override
    public class_5321<class_1937> moonlight$getDimension() {
        return class_5321.method_29179(class_7924.field_41223, moonlight$dimension);
    }


    @Inject(method = "applyToMap", at = @At("HEAD"))
    private void handleExtraData(class_22 mapData, CallbackInfo ci) {
        var serverDeco = this.moonlight$customDecorations;
        var serverData = this.moonlight$customData;

        mapData.field_116 = this.moonlight$mapCenterX;
        mapData.field_115 = this.moonlight$mapCenterZ;
        mapData.field_118 = this.moonlight$getDimension();


        if (mapData instanceof ExpandedMapData ed) {
            Map<String, CustomMapDecoration> decorations = ed.getCustomDecorations();


            //mapData = MapItemSavedData.createForClient(message.scale, message.locked, Minecraft.getInstance().level.dimension());
            //Minecraft.getInstance().level.setMapData(string, mapData);

            if (serverDeco != null) {
                decorations.clear();
                int i;
                for (i = 0; i < serverDeco.length; ++i) {
                    CustomMapDecoration customDecoration = serverDeco[i];
                    if (customDecoration != null) decorations.put("icon-" + i, customDecoration);
                    else {
                        Moonlight.LOGGER.warn("Failed to load custom map decoration, skipping");
                    }
                }

            }
            if (serverData != null) {
                var customData = ed.getCustomData();
                for (var v : customData.values()) {
                    v.loadUpdateTag(this.moonlight$customData);
                }
            }

            //adds dynamic todo use deco instead
            // aaa not optimal but needed for player like behavior
            // update immediately all the times
            for (MapBlockMarker<?> m : MapDataInternal.getDynamicClient(mapId, mapData)) {
                var d = m.createDecorationFromMarker(mapData);
                if (d != null) {
                    decorations.put(m.getMarkerId(), d);
                }
            }
        }
    }

}
