package net.mehvahdjukaar.moonlight.core.mixins;

import com.llamalad7.mixinextras.sugar.Local;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_2170;
import net.minecraft.class_3300;
import net.minecraft.class_5350;
import net.minecraft.class_5455;
import net.minecraft.class_7699;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

@Mixin(class_5350.class)
public abstract class ReloadableServerResourcesMixin {
    @Inject(method = "loadResources", at = @At(value = "HEAD"))
    private static void moonlight$grabRegistryAccess(class_3300 resourceManager,
                                                     class_5455.class_6890 registryAccess,
                                                     class_7699 enabledFeatures,
                                                     class_2170.class_5364 commandSelection,
                                                     int functionCompilationLevel, Executor backgroundExecutor,
                                                     Executor gameExecutor,
                                                     CallbackInfoReturnable<CompletableFuture<class_5350>> cir) {
        Moonlight.setServerRegistryAccess(registryAccess);
    }
    //Disabled indefinitely. THis would fire right AFTER dynamic worldgen regsitries are loaded. Not good for overriding those
    /*
    //should fire right before add reload listener, before packs are reloaded and listeners called
    //should fire right before add reload listener, before packs are reloaded and listeners called
    @WrapOperation(method = "loadResources", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/packs/resources/SimpleReloadInstance;create(Lnet/minecraft/server/packs/resources/ResourceManager;Ljava/util/List;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture;Z)Lnet/minecraft/server/packs/resources/ReloadInstance;"))
    private static ReloadInstance moonlight$dynamicPackEarlyReload(ResourceManager resourceManager, List<PreparableReloadListener> listeners,
                                                                   Executor backgroundExecutor, Executor gameExecutor,
                                                                   CompletableFuture<Unit> alsoWaitedFor, boolean profiled,
                                                                   Operation<ReloadInstance> original,
                                                                   @Local(argsOnly = true) RegistryAccess.Frozen access) {
        //fires on world load or on /reload
        //token to assure that modded resources are included
        if (!(resourceManager instanceof FilteredResManager) &&
                resourceManager.getResource(new ResourceLocation("moonlight:moonlight/token.json")).isPresent()) { //this assumes that it includes all pack including all mod assets
            //one would think that this would be fool proof. Well check again, some mod like to re create this resource manager during block load! All modded resources included aswell
            //so to be EXTRA safe we check if registry phase is over
            if (!PlatHelper.isInitializing()) {
                //hack.we assume its of server type
                return ReloadInstanceWrapper.wrap(
                        () -> {
                            FabricStupid.assignDumbStaticThreadLocal(access);

                            return original.call(resourceManager, listeners, backgroundExecutor, gameExecutor, alsoWaitedFor, profiled);
                        },
                        PackType.SERVER_DATA, resourceManager, backgroundExecutor
                );
            }
        }
        return original.call(resourceManager, listeners, backgroundExecutor, gameExecutor, alsoWaitedFor, profiled);
    }*/
}
