package net.mehvahdjukaar.moonlight.core.mixins;

import net.mehvahdjukaar.moonlight.api.events.EarlyPackReloadEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.moonlight.api.misc.IProgressTracker;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcePack;
import net.mehvahdjukaar.moonlight.core.misc.FilteredResManager;
import net.mehvahdjukaar.moonlight.core.misc.ReloadInstanceWrapper;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_6860;
import net.minecraft.class_6861;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import java.util.Optional;

@Mixin(class_6861.class)
public abstract class ServerMultiPackResourceManagerMixin implements class_6860 {

    //since we are on server thread we can use old method of doing stuff since its non blocking
    //must use this way since other one happens too late
    @Shadow
    public abstract Optional<class_3298> method_14486(class_2960 arg);

    //should fire right before add reload listener, before packs are reloaded and listeners called
    @Inject(method = "<init>", at = @At(value = "RETURN"))
    private void moonlight$serverDynamicPackEarlyReload(class_3264 type, List<class_3262> packs, CallbackInfo cir) {
        if(type != class_3264.field_14190) return; //only for server data packs
        //fires on world load or on /reload
        //token to assure that modded resources are included
        if (!((Object) (this) instanceof FilteredResManager) &&
                this.method_14486(new class_2960("moonlight:moonlight/token.json")).isPresent()) { //this assumes that it includes all pack including all mod assets
            //one would think that this would be fool proof. Well check again, some mod like to re create this resource manager during block load! All modded resources included aswell
            //so to be EXTRA safe we check if registry phase is over
            if (!PlatHelper.isInitializing()) {
                //reload dynamic packs before reloading data packs
                ReloadInstanceWrapper.executeEarlyReloadBlocking(type, this,
                        IProgressTracker.createTree(1));
            }
        }
    }
}

