package net.mehvahdjukaar.moonlight.core.mixins;

import net.mehvahdjukaar.moonlight.api.item.IThirdPersonAnimationProvider;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_4592;
import net.minecraft.class_572;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_572.class)
public abstract class ThirdPersonRendererMixin<T extends class_1309> extends class_4592<T> {

    @Unique
    private boolean moonlight$isTwoHanded = false;

    @Inject(method = "poseRightArm", at = @At(value = "HEAD"), cancellable = true, require = 0)
    public void poseRightArm(T entity, CallbackInfo ci) {
        //cancel offhand animation if two-handed so two-handed animation always happens last
        if (this.moonlight$isTwoHanded) ci.cancel();
        class_1306 handSide = entity.method_6068();
        class_1799 stack = entity.method_5998(handSide == class_1306.field_6183 ? class_1268.field_5808 : class_1268.field_5810);
        IThirdPersonAnimationProvider provider = IThirdPersonAnimationProvider.get(stack.method_7909());
        if (provider != null) {
            if (provider.poseRightArm(stack, (class_572<T>) (Object) this, entity, handSide)) {
                if (provider.isTwoHanded()) moonlight$isTwoHanded = true;
                ci.cancel();
            }
        }
    }

    @Inject(method = "poseLeftArm", at = @At(value = "HEAD"), cancellable = true, require = 0)
    public void poseLeftArm(T entity, CallbackInfo ci) {
        //cancel offhand animation if two-handed so two-handed animation always happens last
        if (this.moonlight$isTwoHanded) ci.cancel();
        class_1306 handSide = entity.method_6068();
        class_1799 stack = entity.method_5998(handSide == class_1306.field_6183 ? class_1268.field_5810 : class_1268.field_5808);
        IThirdPersonAnimationProvider provider = IThirdPersonAnimationProvider.get(stack.method_7909());
        if (provider != null) {
            if (provider.poseLeftArm(stack, (class_572<T>) (Object) this, entity, handSide)) {
                if (provider.isTwoHanded()) moonlight$isTwoHanded = true;
                ci.cancel();
            }
        }
    }

    @Inject(method = "setupAnim*", at = @At(value = "RETURN"), require = 0)
    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        this.moonlight$isTwoHanded = false;
    }
}
