package net.mehvahdjukaar.moonlight.core.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.mehvahdjukaar.moonlight.api.resources.recipe.IRecipeTemplate;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2066;
import net.minecraft.class_2450;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7710;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class ShapelessRecipeTemplate implements IRecipeTemplate<class_2450.class_2451> {

    private final List<Object> conditions = new ArrayList<>();

    public final class_1792 result;
    public final int count;
    public final String group;
    public final List<class_1856> ingredients;
    public final class_7710 category;

    ShapelessRecipeTemplate(ShapedRecipeTemplate shaped) {
        this.result = shaped.result;
        this.count = shaped.count;
        this.group = shaped.group;
        this.ingredients = shaped.keys.values().stream().toList();
        this.category = shaped.category;
    }

    public ShapelessRecipeTemplate(JsonObject json) {
        JsonObject result = json.getAsJsonObject("result");
        class_2960 item = new class_2960(result.get("item").getAsString());
        int count = 1;
        var c = result.get("count");
        if (c != null) count = c.getAsInt();

        this.result = class_7923.field_41178.method_10223(item);
        this.count = count;
        this.category = class_7710.field_40252.method_47920(class_3518.method_15253(json, "category", null), class_7710.field_40251);

        var g = json.get("group");
        this.group = g == null ? "" : g.getAsString();

        List<class_1856> ingredientsList = new ArrayList<>();
        JsonArray ingredients = json.getAsJsonArray("ingredients");
        ingredients.forEach(p -> ingredientsList.add(class_1856.method_52177(p)));

        this.ingredients = ingredientsList;
    }

    @Override
    public <T extends BlockType> class_2450.class_2451 createSimilar(
            @NotNull T originalMat,@NotNull T destinationMat, class_1792 unlockItem, String id) {
        class_1935 newRes = BlockType.changeItemType(this.result, originalMat, destinationMat);
        if (newRes == null) {
            throw new UnsupportedOperationException(String.format("Could not convert output item %s from type %s to %s",
                    this.result, originalMat, destinationMat));
        }

        class_2450 builder = new class_2450(determineBookCategory(this.category),
                newRes, this.count);

        boolean atLeastOneChanged = false;
        for (var originalIng : this.ingredients) {
            class_1856 newIng = IRecipeTemplate.convertIngredients(originalMat, destinationMat, originalIng);
            if (newIng != null) {
                atLeastOneChanged = true;
            }
            //if fail keep the old one
            else newIng = originalIng;
            builder.method_10451(newIng);
        }
        //if recipe fails
        if (!atLeastOneChanged) return null;

        builder.method_10452(group);
        builder.method_10442("has_item", class_2066.class_2068.method_8959(unlockItem));

        AtomicReference<class_2450.class_2451> newRecipe = new AtomicReference<>();

        if (id == null) {
            builder.method_10431(r -> newRecipe.set((class_2450.class_2451) r));
        } else {
            builder.method_36443(r -> newRecipe.set((class_2450.class_2451) r), id);
        }
        return newRecipe.get();
    }


    @Override
    public void addCondition(Object condition) {
        this.conditions.add(condition);
    }

    @Override
    public List<Object> getConditions() {
        return conditions;
    }
}