package net.mehvahdjukaar.moonlight.core.set.fabric;

import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.core.set.BlockSetInternal;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import java.util.*;
import java.util.Map.Entry;

public class BlockSetInternalImpl {

    private static boolean hasFilledBlockSets = false;

    public static boolean hasFilledBlockSets() {
        return hasFilledBlockSets;
    }

    public static final Map<class_2378<?>,
            Map<Class<? extends BlockType>, LateRegQueue<?, ?>>> QUEUES = new HashMap<>();

    @SuppressWarnings("unchecked")
    public static <T extends BlockType, E> void addDynamicRegistration(
            BlockSetAPI.BlockTypeRegistryCallback<E, T> registrationFunction, Class<T> blockType,
            class_2378<E> registry) {
        LateRegQueue<T, E> r = (LateRegQueue<T, E>) QUEUES.computeIfAbsent(registry, b -> new LinkedHashMap<>())
                .computeIfAbsent(blockType, b -> new LateRegQueue<>(blockType, registry));
        r.add(registrationFunction);
    }

    public static void initializeBlockSets() {
        BlockSetInternal.initializeBlockSets();
        hasFilledBlockSets = true;
    }

    public static <T extends class_2378<?>> void registerDynamicEntries(class_5321<? extends T> id) {
        class_2378<T> registry = class_7923.field_41167.method_29107((class_5321) id);
        var q = QUEUES.remove(registry);
        if (q != null) {
            for (var e : q.entrySet()) {
                e.getValue().registerEntries();
            }
        }
    }

    public static void finish() {
        for (var q : QUEUES.values()) {
            for (var e : q.entrySet()) {
                e.getValue().registerEntries();
            }
        }
        QUEUES.clear();
    }

    private static class LateRegQueue<T extends BlockType, E> {
        final Class<T> blockType;
        final Queue<BlockSetAPI.BlockTypeRegistryCallback<E, T>> queue = new ArrayDeque<>();
        final class_2378<E> registry;

        public LateRegQueue(Class<T> blockType, class_2378<E> registry) {
            this.blockType = blockType;
            this.registry = registry;
        }

        public void add(BlockSetAPI.BlockTypeRegistryCallback<E, T> callback) {
            queue.add(callback);
        }

        public void registerEntries() {
            queue.forEach(a -> a.accept((n, i) ->
                    class_2378.method_10230(registry, n, i), BlockSetAPI.getBlockSet(blockType).getValues()));
        }
    }

}
