package net.mehvahdjukaar.moonlight.fabric;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.fabricmc.fabric.impl.resource.conditions.ResourceConditionsImpl;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;

public class ResourceConditionsBridge {

    public static final String CONDITIONS_KEY = "conditions";
    public static final String NON_RECIPE_CONDITIONS_KEY = "global_conditions";
    public static final String CONDITION_ID = "type";

    public static void init() {
        try {
            ResourceConditions.register(new class_2960("forge:not"), ResourceConditionsBridge::forgeNot);
        } catch (Exception ignored) {
        }

        try {
            ResourceConditions.register(new class_2960("forge:or"), ResourceConditionsBridge::forgeOr);
        } catch (Exception ignored) {
        }

        try {
            ResourceConditions.register(new class_2960("forge:and"), ResourceConditionsBridge::forgeAnd);
        } catch (Exception ignored) {
        }

        try {
            ResourceConditions.register(new class_2960("forge:mod_loaded"), ResourceConditionsBridge::forgeModLoaded);
        } catch (Exception ignored) {
        }

        try {
            ResourceConditions.register(new class_2960("forge:tag_empty"), ResourceConditionsBridge::forgeTagEmpty);
        } catch (Exception ignored) {
        }
    }

    private static boolean forgeNot(JsonObject jsonObject) {
        JsonObject jo = class_3518.method_15296(jsonObject, "value");
        return !conditionMatches(jo);
    }

    private static boolean forgeAnd(JsonObject jsonObject) {
        JsonArray jo = class_3518.method_15261(jsonObject, "values");
        return conditionsMatch(jo, true);
    }

    private static boolean forgeOr(JsonObject jsonObject) {
          JsonArray jo = class_3518.method_15261(jsonObject, "values");
          return conditionsMatch(jo, false);
    }

    private static boolean forgeModLoaded(JsonObject jsonObject) {
        return PlatHelper.isModLoaded(class_3518.method_15265(jsonObject, "modid"));
    }

    private static Boolean forgeTagEmpty(JsonObject object) {
        var id = new class_2960(class_3518.method_15265(object, "tag"));
        Map<class_5321<?>, Map<class_2960, Collection<class_6880<?>>>> allTags = ResourceConditionsImpl.LOADED_TAGS.get();
        if (allTags == null) {
            Moonlight.LOGGER.warn("Can't retrieve deserialized tags. Failing tag resource condition check.");
            return true;
        }
        Map<class_2960, Collection<class_6880<?>>> registryTags = allTags.get(class_7924.field_41197);
        if (registryTags == null) {
            // No tag for this registry
            return true;
        }
        Collection<class_6880<?>> tags = registryTags.get(id);
        if (tags == null) return true;
        if (tags.size() == 1 && tags.stream().findFirst().get().comp_349() == class_1802.field_8162) {
            Moonlight.LOGGER.warn("Found broken tag which just contained the empty item: {}", id);
            return true;
        }
        return tags.isEmpty();
    }

    public static void registerSimple(class_2960 id, Predicate<String> predicate) {
        ResourceConditions.register(id, j -> predicate.test(j.get(id.method_12832()).getAsString()));
    }

    public static boolean matchesForgeCondition(JsonObject obj) {
        try {
            if (obj.has("fabric:load_conditions")) return true;
            JsonArray conditions = class_3518.method_15292(obj, NON_RECIPE_CONDITIONS_KEY, null);
            if (conditions == null) {
                conditions = class_3518.method_15292(obj, CONDITIONS_KEY, null);
            }
            if (conditions != null) {
                return conditionsMatch(conditions, true);
            }
        } catch (RuntimeException exception) {
            //Moonlight.LOGGER.warn("Failed to parse resource conditions for %s".formatted(obj), exception);
        }
        return true;

    }

    /**
     * Check if the passed condition object matches.
     *
     * @throws RuntimeException If some condition failed to parse.
     */
    public static boolean conditionMatches(JsonObject condition) throws RuntimeException {
        if (condition.has(CONDITION_ID)) {
            class_2960 conditionId = new class_2960(class_3518.method_15265(condition, CONDITION_ID));
            Predicate<JsonObject> jrc = ResourceConditions.get(conditionId);

            if (jrc == null) {
                throw new JsonParseException("Unknown recipe condition: " + conditionId);
            } else {
                return jrc.test(condition);
            }
        } else return ResourceConditions.conditionMatches(condition);
    }

    public static boolean conditionsMatch(JsonArray conditions, boolean and) throws RuntimeException {
        for (JsonElement element : conditions) {
            if (element.isJsonObject()) {
                if (conditionMatches(element.getAsJsonObject()) != and) {
                    return !and;
                }
            } else {
                throw new JsonParseException("Invalid condition entry: " + element);
            }
        }
        return and;
    }
}
