/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.fabric;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.mehvahdjukaar.moonlight.api.client.fabric.IFabricMenuType;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.misc.TriFunction;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.platform.fabric.RegistryQueue;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.misc.AntiRepostWarning;
import net.mehvahdjukaar.moonlight.core.mixins.fabric.PoiTypeAccessor;
import net.mehvahdjukaar.moonlight.core.set.fabric.BlockSetInternalImpl;
import net.mehvahdjukaar.moonlight.fabric.MoonlightFabric;
import net.mehvahdjukaar.moonlight.fabric.ResourceConditionsBridge;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1761;
import net.minecraft.class_1781;
import net.minecraft.class_1792;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2582;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import net.minecraft.class_4158;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_6880;
import net.minecraft.class_7477;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_83;
import org.jetbrains.annotations.ApiStatus;

public class RegHelperImpl {
    public static final Map<class_5321<? extends class_2378<?>>, Map<String, RegistryQueue<?>>> REGISTRIES = new LinkedHashMap();
    public static final List<class_5321<? extends class_2378<?>>> REG_PRIORITY = List.of(class_7924.field_41225, class_7924.field_41270, class_7924.field_41254, class_7924.field_41210, class_7924.field_41266, class_7924.field_41208, class_7924.field_41197, class_7924.field_41255, class_7924.field_41211, class_7924.field_41231, class_7924.field_41227, class_7924.field_41267, class_7924.field_41239, class_7924.field_41245);

    @ApiStatus.Internal
    public static void lateRegisterEntries() {
        for (Map.Entry<class_5321<class_2378<?>>, Map<String, RegistryQueue<?>>> reg : REGISTRIES.entrySet()) {
            Map<String, RegistryQueue<?>> v = reg.getValue();
            List sorted = v.keySet().stream().sorted().toList();
            for (String s : sorted) {
                try {
                    v.get(s).initializeEntries();
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to initialize registry objects for namespace [" + s + "]", e);
                }
            }
            if (reg.getKey() == class_7924.field_41254) {
                BlockSetInternalImpl.initializeBlockSets();
            }
            BlockSetInternalImpl.registerDynamicEntries(reg.getKey());
        }
        BlockSetInternalImpl.finish();
    }

    public static void finishRegistration(String modId) {
        for (Map.Entry<class_5321<class_2378<?>>, Map<String, RegistryQueue<?>>> r : REGISTRIES.entrySet()) {
            Map<String, RegistryQueue<?>> m = r.getValue();
            RegistryQueue<?> v = m.get(modId);
            if (v == null) continue;
            v.initializeEntries();
            m.remove(modId);
        }
    }

    public static <T, E extends T> RegSupplier<E> register(class_2960 name, Supplier<E> supplier, class_5321<? extends class_2378<T>> reg) {
        if (reg.equals((Object)class_7924.field_41252)) {
            class_2582 p = (class_2582)supplier.get();
            class_2378.method_10230((class_2378)class_7923.field_41165, (class_2960)name, (Object)p);
            return new RegSupplier.Direct<class_2582>(p, class_7923.field_41165);
        }
        if (supplier == null) {
            throw new IllegalArgumentException("Registry entry Supplier for " + String.valueOf(name) + " can't be null");
        }
        if (name.method_12836().equals("minecraft")) {
            throw new IllegalArgumentException("Registering under minecraft namespace is not supported");
        }
        String modId = name.method_12836();
        Map m = REGISTRIES.computeIfAbsent(reg, h -> new LinkedHashMap());
        RegistryQueue registry = m.computeIfAbsent(modId, c -> {
            if (PlatHelper.getPhysicalSide().isClient()) {
                AntiRepostWarning.addMod(modId);
            }
            return new RegistryQueue(reg);
        });
        if (reg.equals((Object)class_7924.field_41212)) {
            PlatHelper.addCommonSetup(() -> {
                class_6880.class_6883 holder = class_7923.field_41128.method_40290(class_5321.method_29179((class_5321)class_7924.field_41212, (class_2960)name));
                class_7477.method_43990((class_6880)holder, (Set)((class_4158)holder.comp_349()).comp_815());
            });
        }
        return registry.add(supplier, name);
    }

    public static <T, E extends T> RegSupplier<E> registerAsync(class_2960 name, Supplier<E> supplier, class_5321<? extends class_2378<T>> reg) {
        RegistryQueue.EntryWrapper entry = new RegistryQueue.EntryWrapper(name, supplier, reg);
        entry.initialize();
        return entry;
    }

    public static <T> void registerInBatch(class_2378<T> reg, Consumer<Registrator<T>> eventListener) {
        Map m = REGISTRIES.computeIfAbsent(reg.method_30517(), h -> new LinkedHashMap());
        RegistryQueue registry = m.computeIfAbsent("a", c -> new RegistryQueue(reg.method_30517()));
        registry.add(eventListener);
    }

    public static <T extends class_3611> RegSupplier<T> registerFluid(class_2960 name, Supplier<T> fluid) {
        return RegHelperImpl.register(name, fluid, class_7924.field_41270);
    }

    public static <T extends class_3955> RegSupplier<class_1865<T>> registerSpecialRecipe(class_2960 name, class_1866.class_7711<T> factory) {
        return RegHelper.registerRecipeSerializer(name, () -> new class_1866(factory));
    }

    public static <C extends class_1703> RegSupplier<class_3917<C>> registerMenuType(class_2960 name, TriFunction<Integer, class_1661, class_2540, C> containerFactory) {
        return RegHelperImpl.register(name, () -> IFabricMenuType.create(containerFactory::apply), class_7924.field_41207);
    }

    public static <T extends class_1297> RegSupplier<class_1299<T>> registerEntityType(class_2960 name, class_1299.class_4049<T> factory, class_1311 category, float width, float height, int clientTrackingRange, int updateInterval) {
        Supplier<class_1299> s = () -> class_1299.class_1300.method_5903((class_1299.class_4049)factory, (class_1311)category).method_17687(width, height).method_5905(name.toString());
        return RegHelperImpl.register(name, s, class_7924.field_41266);
    }

    public static void registerItemBurnTime(class_1792 item, int burnTime) {
        FuelRegistry.INSTANCE.add((class_1935)item, (Object)burnTime);
    }

    public static void registerBlockFlammability(class_2248 item, int fireSpread, int flammability) {
        FlammableBlockRegistry.getDefaultInstance().add(item, fireSpread, flammability);
    }

    public static void registerVillagerTrades(class_3852 profession, int level, Consumer<List<class_3853.class_1652>> factories) {
        Moonlight.assertInitPhase();
        MoonlightFabric.PRE_SETUP_WORK.add(() -> TradeOfferHelper.registerVillagerOffers((class_3852)profession, (int)level, (Consumer)factories));
    }

    public static void registerWanderingTraderTrades(int level, Consumer<List<class_3853.class_1652>> factories) {
        MoonlightFabric.PRE_SETUP_WORK.add(() -> TradeOfferHelper.registerWanderingTraderOffers((int)level, (Consumer)factories));
    }

    public static void addAttributeRegistration(Consumer<RegHelper.AttributeEvent> eventListener) {
        Moonlight.assertInitPhase();
        MoonlightFabric.PRE_SETUP_WORK.add(() -> eventListener.accept(FabricDefaultAttributeRegistry::register));
    }

    public static void addSpawnPlacementsRegistration(Consumer<RegHelper.SpawnPlacementEvent> eventListener) {
        Moonlight.assertInitPhase();
        MoonlightFabric.PRE_SETUP_WORK.add(() -> eventListener.accept(new SpawnPlacementsImpl()));
    }

    public static void addCommandRegistration(RegHelper.CommandRegistration eventListener) {
        Moonlight.assertInitPhase();
        CommandRegistrationCallback.EVENT.register(eventListener::accept);
    }

    public static void registerSimpleRecipeCondition(class_2960 id, Predicate<String> predicate) {
        Moonlight.assertInitPhase();
        ResourceConditionsBridge.registerSimple(id, predicate);
    }

    public static void addItemsToTabsRegistration(Consumer<RegHelper.ItemToTabEvent> eventListener) {
        Moonlight.assertInitPhase();
        MoonlightFabric.AFTER_SETUP_WORK.add(() -> {
            RegHelper.ItemToTabEvent event = new RegHelper.ItemToTabEvent((tab, target, after, items) -> ItemGroupEvents.modifyEntriesEvent((class_5321)tab).register(entries -> {
                if (target == null) {
                    entries.method_45423(items);
                } else if (after.booleanValue()) {
                    entries.addAfter(target, items, class_1761.class_7705.field_40191);
                } else {
                    entries.addBefore(target, items, class_1761.class_7705.field_40191);
                }
            }));
            eventListener.accept(event);
        });
    }

    public static RegSupplier<class_1761> registerCreativeModeTab(class_2960 name, boolean search, List<class_2960> beforeEntries, List<class_2960> afterEntries, Consumer<class_1761.class_7913> configurator) {
        return RegHelperImpl.register(name, () -> {
            class_1761.class_7913 builder = FabricItemGroup.builder();
            configurator.accept(builder);
            return builder.method_47324();
        }, class_7924.field_44688);
    }

    public static void addLootTableInjects(Consumer<RegHelper.LootInjectEvent> eventListener) {
        Moonlight.assertInitPhase();
        LootTableEvents.MODIFY.register((resourceManager, lootManager, id, tableBuilder, source) -> eventListener.accept(new RegHelper.LootInjectEvent(){

            @Override
            public class_2960 getTable() {
                return id;
            }

            @Override
            public void addTableReference(class_2960 targetId) {
                class_55 pool = class_55.method_347().method_351((class_79.class_80)class_83.method_428((class_2960)targetId)).method_355();
                tableBuilder.pool(pool);
            }
        }));
    }

    public static void registerFireworkRecipe(class_1781.class_1782 shape, class_1792 ingredient) {
    }

    public static <T> Supplier<class_2941<T>> regEntityDataSerializer(class_2960 name, Supplier<class_2941<T>> serializer) {
        class_2941 value = serializer.get();
        class_2943.method_12720(value);
        return () -> value;
    }

    public static void addBlocksToPOI(class_5321<class_4158> poi, Iterable<? extends class_2248> blocks) {
        class_6880.class_6883 beehivePOI = class_7923.field_41128.method_40290(poi);
        HashSet<class_2680> matchingStates = new HashSet<class_2680>(((class_4158)beehivePOI.comp_349()).comp_815());
        HashSet<class_2680> newStates = new HashSet<class_2680>();
        for (class_2248 class_22482 : blocks) {
            matchingStates.add(class_22482.method_9564());
            newStates.add(class_22482.method_9564());
        }
        ((PoiTypeAccessor)beehivePOI.comp_349()).setMatchingStates(matchingStates);
        class_7477.method_43990((class_6880)beehivePOI, newStates);
    }

    static {
        REG_PRIORITY.forEach(e -> REGISTRIES.put((class_5321<class_2378<?>>)e, new LinkedHashMap()));
    }

    static class SpawnPlacementsImpl
    implements RegHelper.SpawnPlacementEvent {
        SpawnPlacementsImpl() {
        }

        @Override
        public <T extends class_1297> void register(class_1299<T> entityType, class_1317.class_1319 decoratorType, class_2902.class_2903 heightMapType, class_1317.class_4306<T> decoratorPredicate) {
            try {
                class_1317.method_20637(entityType, (class_1317.class_1319)decoratorType, (class_2902.class_2903)heightMapType, decoratorPredicate);
            }
            catch (Exception e) {
                Moonlight.LOGGER.warn("Skipping placement registration for {} as its not of Mob type", entityType);
            }
        }
    }
}

