package net.mehvahdjukaar.moonlight.api.block;

import net.mehvahdjukaar.moonlight.api.client.IScreenProvider;
import net.mehvahdjukaar.moonlight.api.misc.TileOrEntityTarget;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import org.jetbrains.annotations.Nullable;

import java.util.UUID;

// Interface for tile entities that can be edited by one player at a time like signs and such
public interface IOnePlayerInteractable {

    void setPlayerWhoMayEdit(@Nullable UUID uuid);

    UUID getPlayerWhoMayEdit();

    //call before access
    default boolean isEditingPlayer(class_2338 myPos, class_1657 player) {
        //player who may edit is a server side concept. here we just check if player is close by
        if (player.method_37908().field_9236) {
            return isCloseEnoughToEdit(player, myPos);
        }
        validateEditingPlayer(myPos, player.method_37908());
        UUID uuid = this.getPlayerWhoMayEdit();
        return uuid != null && uuid.equals(player.method_5667());
    }

    default boolean isOtherPlayerEditing(class_2338 myPos, class_1657 otherThan) {
        validateEditingPlayer(myPos, otherThan.method_37908());
        UUID uuid = this.getPlayerWhoMayEdit();
        return uuid != null && !uuid.equals(otherThan.method_5667());
    }


    private void validateEditingPlayer(class_2338 myPos, class_1937 level) {
        if (level == null) {
            this.setPlayerWhoMayEdit(null);
            return;
        }
        UUID uuid = this.getPlayerWhoMayEdit();
        if (uuid == null) return;

        class_1657 player = level.method_18470(uuid);
        if (player == null || !isCloseEnoughToEdit(player, myPos)) {
            this.setPlayerWhoMayEdit(null);
        }
    }

    private boolean isCloseEnoughToEdit(class_1657 player, class_2338 myPos) {
        return player.method_56093(myPos, 8);
    }

    default boolean tryOpeningEditGui(class_3222 player, class_2338 pos, class_1799 stack, class_2350 hitFace) {
        //this is likely not needed
        if (Utils.mayPerformBlockAction(player, pos, stack) && !this.isOtherPlayerEditing(pos, player)) {
            // open gui (edit sign with empty hand)
            this.setPlayerWhoMayEdit(player.method_5667());

            if (this instanceof IScreenProvider sp) {
                sp.sendOpenGuiPacket(player, hitFace);
                return false;
            }
            if (this instanceof class_3908 mp && this instanceof class_2586 be) {
                TileOrEntityTarget target = TileOrEntityTarget.of(be);
                PlatHelper.openCustomMenu(player, mp, target::write);
                return true;
            }
        }
        return false;
    }
}
