package net.mehvahdjukaar.moonlight.api.block;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2669;
import net.minecraft.class_2680;

/**
 * Callback for piston movement reaction on blocks
 */
public interface IPistonMotionReact {

    /**
     * Called on movement finished
     */
    default void onMoved(class_1937 level, class_2338 pos, class_2680 movedState,  class_2350 direction, boolean extending) {
    }

    default boolean ticksWhileMoved() {
        return false;
    }

    /**
     * Called while moving
     */
    default void moveTick(class_1937 level, class_2338 pos, class_2680 movedState, class_238 aabb, class_2669 tile) {
    }

    /**
     * Quark method for magnet callback
     */
    default void onMagnetMoved(class_1937 level, class_2338 blockPos, class_2350 direction, class_2680 blockState, class_2586 blockEntity) {
    }
}
