package net.mehvahdjukaar.moonlight.api.block;


import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_7225;


public abstract class MimicBlockTile extends class_2586 implements IBlockHolder, IExtraModelDataProvider {

    public static final ModelDataKey<class_2680> MIMIC_KEY = new ModelDataKey<>(class_2680.class);

    protected class_2680 mimic = class_2246.field_10124.method_9564();

    protected MimicBlockTile(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addExtraModelData(ExtraModelData.Builder builder) {
        builder.with(MIMIC_KEY, getHeldBlock());
    }

    @Override
    public class_2680 getHeldBlock(int index) {
        return this.mimic;
    }

    @Override
    public boolean setHeldBlock(class_2680 state, int index) {
        if (index == 0) {
            this.mimic = state;
            return true;
        }
        return false;
    }

    @Override
    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        setHeldBlock(Utils.readBlockState(tag.method_10562("Mimic"), field_11863), 0);
    }

    @Override
    public void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        tag.method_10566("Mimic", class_2512.method_10686(mimic));
    }

    @Override
    public class_2622 method_38235() {
        return class_2622.method_38585(this);
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 registries) {
        return this.method_38244(registries);
    }

}