package net.mehvahdjukaar.moonlight.api.block;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.mehvahdjukaar.moonlight.api.fluids.ModFlowingFluid;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_2404;
import net.minecraft.class_3609;
import net.minecraft.class_3612;
import net.minecraft.class_7923;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.function.Supplier;

public class ModLiquidBlock extends class_2404 {

    private static final Codec<class_3609> FLOWING_FLUID = class_7923.field_41173.method_39673().comapFlatMap((fluid) -> {
        DataResult<class_3609> result;
        if (fluid instanceof class_3609 flowingFluid) {
            result = DataResult.success(flowingFluid);
        } else {
            result = DataResult.error(() -> "Not a flowing fluid: " + fluid);
        }
        return result;
    }, (flowingFluid) -> flowingFluid);

    public static final MapCodec<ModLiquidBlock> CODEC = RecordCodecBuilder.mapCodec((i) -> i.group(
            FLOWING_FLUID.fieldOf("fluid").forGetter(ModLiquidBlock::getFlowingFluid), method_54096()
    ).apply(i, (f, s) -> new ModLiquidBlock(() -> f, s)));

    private static Field FORGE_BLOCK_SUPPLIER;
    private static Field INIT;
    private final Supplier<? extends class_3609> fluidState;

    public ModLiquidBlock(Supplier<? extends class_3609> supplier, class_2251 arg) {
        super(PlatHelper.getPlatform().isFabric() ? supplier.get() : class_3612.field_15910, arg);
        if (PlatHelper.getPlatform().isForge()) {
            if (FORGE_BLOCK_SUPPLIER == null)
                FORGE_BLOCK_SUPPLIER = PlatHelper.findField(class_2404.class, "supplier");
            if (INIT == null) INIT = PlatHelper.findField(class_2404.class, "fluidStateCacheInitialized");
            try {
                for (var f : class_2404.class.getDeclaredFields()) {
                    if (f.getType() == class_3609.class) {
                        f.setAccessible(true);
                        f.set(this, null);
                    } else if (f.getType() == ArrayList.class) {
                        f.setAccessible(true);
                        f.set(this, Lists.newArrayList());
                    }
                }
                INIT.setAccessible(true);
                INIT.set(this, false);
                this.method_9590(this.field_10647.method_11664().method_11657(field_11278, 0));
                FORGE_BLOCK_SUPPLIER.setAccessible(true);
                FORGE_BLOCK_SUPPLIER.set(this, supplier);
                INIT.set(this, false);
            } catch (Exception e) {
                Moonlight.LOGGER.error("Failed to setup ModLiquidBlock class : " + e);
                throw new RuntimeException(e);
            }
        }
        this.fluidState = supplier;

    }

    public class_3609 getFlowingFluid() {
        return this.fluidState.get();
    }

    @SuppressWarnings("all")
    @Override
    public MapCodec method_53969() {
        return field_46390;
    }
}
