package net.mehvahdjukaar.moonlight.api.client;

import com.mojang.datafixers.util.Pair;
import org.jetbrains.annotations.Nullable;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1935;
import net.minecraft.class_2960;

//used for quick access when recoloring textures
public class TextureCache {

    /**
     * Hacky method to add weird textures for blocks that have ones with odd names that might not get picked up.
     * Useful for block sets to specify exactly which texture to use for their needs
     *
     * @param block       target block
     * @param id          id that will be used to identify this texture. needs to match the criteria that are used to normally identify textures inside a model
     * @param texturePath actual texture location. It is not its absolute path so no :textures/
     */
    public static void registerSpecialTextureForBlock(class_1935 block, String id, class_2960 texturePath) {
        SPECIAL_TEXTURES.computeIfAbsent(block, b -> new HashSet<>()).add(new Pair<>(id, texturePath.toString()));
    }

    private static final Map<class_1935, Set<Pair<String, String>>> SPECIAL_TEXTURES = new IdentityHashMap<>();

    private static final Map<class_1935, Set<String>> CACHED_TEXTURES = new IdentityHashMap<>();

    public static void clear() {
        CACHED_TEXTURES.clear();
    }

    @Nullable
    public static String getCached(class_1935 block, Predicate<String> texturePredicate) {
        var special = SPECIAL_TEXTURES.get(block);
        if (special != null) {
            for (var e : special) {
                if (texturePredicate.test(e.getFirst())) return e.getSecond();
            }
        }
        var list = CACHED_TEXTURES.get(block);
        if (list != null) {
            for (var e : list) {
                if (texturePredicate.test(e)) return e;
            }
        }
        return null;
    }

    public static void add(class_1935 block, String t) {
        CACHED_TEXTURES.computeIfAbsent(block, b -> new HashSet<>()).add(t);
    }

}
