package net.mehvahdjukaar.moonlight.api.client.model.fabric;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import net.mehvahdjukaar.moonlight.api.client.model.CustomModelLoader;
import net.minecraft.class_2960;
import net.minecraft.class_793;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.Map;

public class MLFabricModelLoaderRegistry {

    private static final Map<class_2960, CustomModelLoader> DESERIALIZER_MAP = new HashMap<>();

    public static void registerLoader(class_2960 name, CustomModelLoader deserializer) {
        DESERIALIZER_MAP.put(name, deserializer);
    }

    @Nullable
    public static class_793 getUnbakedModel(class_2960 loader,
                                             JsonDeserializationContext context, JsonObject jsonobject,
                                             class_793 original) {
        var d = DESERIALIZER_MAP.get(loader);
        if (d == null) {
           // Moonlight.LOGGER.error("Unknown model loader: {}", loader);
            return null;
        }
        return new BlockModelWithCustomGeo(original, d.deserialize(jsonobject,context));
    }
}
