package net.mehvahdjukaar.moonlight.api.client.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.minecraft.class_1767;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_7225;
import net.minecraft.class_765;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;

import java.util.List;
import java.util.function.BooleanSupplier;

public class TextUtil {

    private static final class_5481 CURSOR_MARKER = class_5481.method_30747("_", class_2583.field_24360);

    //IDK how this works anymore...

    /**
     * Scales and splits the given lines such that they fix in the given area with the maximum possible scale
     *
     * @param text   original text
     * @param width  box width
     * @param height box height
     * @return Pair of split lines and scale at which they should be rendered
     */
    public static Pair<List<class_5481>, Float> fitLinesToBox(class_327 font, class_5348 text, float width, float height) {
        int scalingFactor;
        List<class_5481> splitLines;
        int fontWidth = font.method_27525(text);

        float maxLines;
        do {
            scalingFactor = class_3532.method_15375(class_3532.method_15355((fontWidth * 8f) / (width * height)));

            splitLines = font.method_1728(text, class_3532.method_15375(width * scalingFactor));
            //tempPageLines = RenderComponentsUtil.splitText(txt, MathHelper.floor(lx * scalingfactor), font, true, true);

            maxLines = height * scalingFactor / 8f;
            fontWidth += 1;
            // when lines fully filled @scaling factor > actual lines -> no overflow lines
        } while (maxLines < splitLines.size());

        return Pair.of(splitLines, 1f / scalingFactor);
    }

    public static class_5348 parseText(String s, @Nullable class_7225.class_7874 provider) {
        try {
            class_5348 mutableComponent = class_2561.class_2562.method_10877(s, provider);
            if (mutableComponent != null) {
                return mutableComponent;
            }
        } catch (Exception ignored) {
        }
        return class_5348.method_29430(s);
    }

    @Deprecated(forRemoval = true)
    public static class_5348 parseText(String s) {
        return parseText(s, Utils.hackyGetRegistryAccess());
    }


    /**
     * Render a line in a GUI
     */
    public static void renderGuiLine(RenderProperties properties, String string, class_327 font, class_332 graphics,
                                     class_4597.class_4598 buffer,
                                     int cursorPos, int selectionPos, boolean isSelected, boolean blink, int yOffset) {
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        Matrix4f matrix4f = poseStack.method_23760().method_23761();

        if (string != null) {
            if (font.method_1726()) {
                string = font.method_1721(string);
            }
            //int centerX = (-font.width(string) / 2);

            class_5481 charSequence = class_5481.method_30747(string, properties.style);
            float centerX = -font.method_30880(charSequence) / 2f;
            renderLineInternal(charSequence, font, centerX, yOffset, matrix4f, buffer, properties);

            String substring = string.substring(0, Math.min(cursorPos, string.length()));
            if (isSelected) {

                int pX = (int) (font.method_30880(class_5481.method_30747(substring, properties.style)) + centerX);

                if (blink) {
                    if (cursorPos >= string.length()) {
                        renderLineInternal(CURSOR_MARKER, font, pX, yOffset, matrix4f, buffer, properties);
                    }
                    buffer.method_22993();
                }

                //highlight
                if (blink && cursorPos < string.length()) {
                    graphics.method_25294(pX, yOffset - 1, pX + 1, yOffset + 9, -16777216 | properties.textColor);
                }

                if (selectionPos != cursorPos) {
                    int l3 = Math.min(cursorPos, selectionPos);
                    int l1 = Math.max(cursorPos, selectionPos);
                    int i2 = font.method_1727(string.substring(0, l3)) - font.method_1727(string) / 2;
                    int j2 = font.method_1727(string.substring(0, l1)) - font.method_1727(string) / 2;
                    int startX = Math.min(i2, j2);
                    int startY = Math.max(i2, j2);


                    RenderSystem.enableColorLogicOp();
                    RenderSystem.logicOp(GlStateManager.class_1030.field_5110);
                    graphics.method_25294(startX, startY, yOffset, (yOffset + 9), -16776961);
                    RenderSystem.disableColorLogicOp();

                }
            }
            if (!(isSelected && blink)) {
                buffer.method_22993();
            }
        }
    }

    /**
     * Renders multiple lines in a GUI
     */
    public static void renderGuiText(RenderProperties properties, String[] guiLines, class_327 font, class_332 graphics,
                                     class_4597.class_4598 buffer,
                                     int cursorPos, int selectionPos, int currentLine, boolean blink, int lineSpacing) {

        int nOfLines = guiLines.length;

        for (int line = 0; line < nOfLines; ++line) {
            int yOffset = line * lineSpacing - nOfLines * 5;
            renderGuiLine(properties, guiLines[line], font, graphics, buffer, cursorPos, selectionPos,
                    line == currentLine, blink, yOffset);
        }
    }

    /**
     * Render text line in world
     */
    public static void renderLine(class_5481 formattedCharSequences, class_327 font, float yOffset, class_4587 poseStack,
                                  class_4597 buffer, RenderProperties properties) {
        if (formattedCharSequences == null) return;
        float x = -font.method_30880(formattedCharSequences) / 2f;
        renderLineInternal(formattedCharSequences, font, x, yOffset, poseStack.method_23760().method_23761(), buffer, properties);
    }

    /**
     * Renders multiple lines in world
     */
    public static void renderAllLines(class_5481[] charSequences, int ySeparation, class_327 font, class_4587 poseStack,
                                      class_4597 buffer, RenderProperties properties) {
        for (int i = 0; i < charSequences.length; i++) {
            renderLine(charSequences[i], font, ySeparation * i, poseStack, buffer, properties);
        }
    }

    private static void renderLineInternal(class_5481 formattedCharSequences, class_327 font, float xOffset, float yOffset,
                                           Matrix4f matrix4f, class_4597 buffer, RenderProperties properties) {
        if (properties.outline) {
            font.method_37296(formattedCharSequences, xOffset, yOffset, properties.textColor, properties.darkenedColor,
                    matrix4f, buffer, properties.light);
        } else {
            font.method_22942(formattedCharSequences, xOffset, yOffset, properties.darkenedColor, false,
                    matrix4f, buffer, class_327.class_6415.field_33993, 0, properties.light);
        }
    }


    private static int getDarkenedColor(int color, boolean glowing, float mult) {
        if (color == class_1767.field_7963.method_16357() && glowing) return 0xFFF0EBCC;
        return ColorUtils.multiply(color, 0.4f * (glowing ? 1 : mult));
    }

    private static int getDarkenedColor(int color, boolean glowing) {
        return getDarkenedColor(color, glowing, 1);
    }

    //TODO: account for light. text doesnt account for light direction

    /**
     * bundles all data needed to render a generic text line. Useful for signs like blocks
     */
    public record RenderProperties(int textColor, int darkenedColor, boolean outline, int light, class_2583 style) {
    }

    public static RenderProperties renderProperties(class_1767 dyeColor, boolean glowing,
                                                    int combinedLight, class_2583 style, Vector3f normal, BooleanSupplier isVeryNear) {
        return renderProperties(dyeColor, glowing, 1, combinedLight, style, normal, isVeryNear);
    }

    public static RenderProperties renderProperties(class_1767 dyeColor, boolean glowing, float darkColorMult,
                                                    int combinedLight, class_2583 style, Vector3f normal, BooleanSupplier isVeryNear) {
        boolean outline = glowing && (dyeColor == class_1767.field_7963 || isVeryNear.getAsBoolean());

        int textColor = dyeColor.method_16357();
        float shading = ColorUtils.getShading(normal);
        int color = glowing ? textColor : ColorUtils.multiply(textColor, shading);
        int dark;
        if (!glowing || outline) {
            dark = getDarkenedColor(textColor, glowing, darkColorMult * shading);
        } else {
            dark = color;
        }
        return new RenderProperties(color, dark, outline, glowing ? class_765.field_32767 : combinedLight, style);
    }


}
