package net.mehvahdjukaar.moonlight.api.map;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_22;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;


public interface CustomMapData<C extends CustomMapData.DirtyCounter, P> {


    record Type<P, T extends CustomMapData<?, P>>(class_2960 id, Supplier<T> factory,
                                                  class_9139<? super class_9129, P> patchCodec) {

        public static final Codec<Type<?, ?>> CODEC = MapDataInternal.getMapDataRegistry().method_39673();
        public static final class_9139<class_9129, Type<?, ?>> STREAM_CODEC = class_9135.method_56365(MapDataInternal.getMapDataRegistry().method_30517());

        @SuppressWarnings("unchecked")
        @NotNull
        public T get(class_22 mapData) {
            return (T) ((ExpandedMapData) mapData).ml$getCustomData().get(this);
        }

    }

    Type<P, ?> getType();

    default boolean persistOnCopyOrLock() {
        return true;
    }

    default boolean persistOnRescale(){
        return true;
    }

    default boolean onItemUpdate(class_22 data, class_1297 entity) {
        return false;
    }

    @Nullable
    default class_2561 onItemTooltip(class_22 data, class_1799 stack) {
        return null;
    }

    C createDirtyCounter();

    void load(class_2487 tag, class_7225.class_7874 lookup);

    void save(class_2487 tag, class_7225.class_7874 lookup);

    P createUpdatePatch(C dirtyCounter);

    void applyUpdatePatch(P patch);

    default void setDirty(class_22 data, Consumer<C> dirtySetter) {
        Type<P, ?> type = this.getType();
        ((ExpandedMapData) data).ml$setCustomDataDirty(type, dirtySetter);
    }

    interface DirtyCounter {

        boolean isDirty();

        void clearDirty();
    }

    // what's send via packet. Wraps the patch with its type to be able to decode it later
    record DirtyDataPatch<P, D extends CustomMapData<?, P>>(CustomMapData.Type<P, D> type, P patch) {
        public static final class_9139<class_9129, DirtyDataPatch<?, ?>> STREAM_CODEC = new class_9139<>() {

            @Override
            public void encode(class_9129 buf, DirtyDataPatch<?, ?> dirtyData) {
                Type.STREAM_CODEC.encode(buf, dirtyData.type);
                encodeTyped(buf, dirtyData);
            }

            private static <P> void encodeTyped(class_9129 buf, DirtyDataPatch<P, ?> dirtyData) {
                dirtyData.type.patchCodec().encode(buf, dirtyData.patch);
            }

            @Override
            public DirtyDataPatch<?, ?> decode(class_9129 buf) {
                CustomMapData.Type<?, ?> type = Type.STREAM_CODEC.decode(buf);
                return decodeTyped(buf, type);
            }

            private static <P, D extends CustomMapData<?, P>> DirtyDataPatch<P, D> decodeTyped(class_9129 buf, Type<P, D> type) {
                P decode = type.patchCodec().decode(buf);
                return new DirtyDataPatch<>(type, decode);
            }
        };

        public void apply(Map<Type<?, ?>, CustomMapData<?, ?>> customData) {
            CustomMapData<?, P> data = (CustomMapData<?, P>) customData.get(this.type);
            data.applyUpdatePatch(this.patch);
        }
    }

    // simple implementation for simple data

    class SimpleDirtyCounter implements DirtyCounter {
        private boolean dirty = true;

        public void markDirty() {
            this.dirty = true;
        }

        public boolean isDirty() {
            return dirty;
        }

        @Override
        public void clearDirty() {
            dirty = false;
        }
    }

    abstract class Simple<O> implements CustomMapData<SimpleDirtyCounter, O>{
        
        public Simple(O defaultValue) {
            this.value = defaultValue;
        }

        @Deprecated(forRemoval = true)
        public Simple() {
        }

        protected O value;

        @Override
        public Type<O, ?> getType() {
            return null;
        }

        @Override
        public SimpleDirtyCounter createDirtyCounter() {
            return new SimpleDirtyCounter();
        }

        @Override
        public O createUpdatePatch(SimpleDirtyCounter dirtyCounter) {
            return value;
        }

        @Override
        public void applyUpdatePatch(O patch) {
            this.value = patch;
        }
    }

}

