package net.mehvahdjukaar.moonlight.api.map;

import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecorationType;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapMarker;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLSpecialMapDecorationType;
import net.mehvahdjukaar.moonlight.api.misc.HolderReference;
import net.mehvahdjukaar.moonlight.api.misc.TriFunction;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9209;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public class MapDataRegistry {


    @Deprecated(forRemoval = true)
    public static final class_5321<class_2378<MLMapDecorationType<?, ?>>> REGISTRY_KEY = MapDataInternal.MAP_DECORATION_REGISTRY_KEY ;
    public static final class_5321<class_2378<MLMapDecorationType<?, ?>>> MAP_DECORATION_REGISTRY_KEY = MapDataInternal.MAP_DECORATION_REGISTRY_KEY ;

    public static final HolderReference<MLMapDecorationType<?, ?>> GENERIC_STRUCTURE_MARKER = HolderReference.of(MapDataInternal.GENERIC_STRUCTURE_ID,
            MAP_DECORATION_REGISTRY_KEY);

    /**
     * Registers a custom data type to be stored in map data. Type will provide its onw data implementation
     **/
    public static <P, T extends CustomMapData<?, P>> CustomMapData.Type<P, T> registerCustomMapSavedData(CustomMapData.Type<P, T> type) {
        return MapDataInternal.registerCustomMapSavedData(type);
    }

    public static <P, T extends CustomMapData<?, P>> CustomMapData.Type<P, T> registerCustomMapSavedData(
            class_2960 id, Supplier<T> factory,
            class_9139<? super class_9129, P> patchCodec) {
        return registerCustomMapSavedData(new CustomMapData.Type<>(id, factory, patchCodec));
    }

    /**
     * Call before mod setup. Register a code defined map marker type. You will still need to add a related json file
     */
    //TODO: this is bad. rethink type stuff
    //we have instances of markers per map. these have a type which determines their type
    //each type is assigned to one and one only json file. essntally the type is what is parsed from json.
    //each type can intern have its own type.., the custom factory
    public static void registerSpecialMapDecorationTypeFactory(class_2960 factoryId, Supplier<MLSpecialMapDecorationType<?, ?>> decorationTypeFactory) {
        MapDataInternal.registerCustomType(factoryId, decorationTypeFactory);
    }

    /**
     * Use to add non-permanent decoration like player icon, only visible to player holding the map.
     * Called by the client every time map marker would change.
     * This means that for moving ones you should manage this yourself with a client tick event
     *
     * @param event callback
     */
    public static void addDynamicClientMarkersEvent(BiFunction<class_9209, class_22, Set<MLMapMarker<?>>> event) {
        MapDataInternal.addDynamicClientMarkersEvent(event);
    }

    /**
     * Use to add non-permanent per-player decoration like player icon, only visible to player holding the map.
     * Called by server every couple minutes and synced to the client.
     * Whether these will be saved or not is up to the marker provided
     *
     * @param event callback
     */
    public static void addDynamicServerMarkersEvent(TriFunction<class_1657, class_9209, class_22, Set<MLMapMarker<?>>> event) {
        MapDataInternal.addDynamicServerMarkersEvent(event);
    }


    @Deprecated(forRemoval = true)
    public static MLMapDecorationType<?, ?> getAssociatedType(class_6880<class_3195> structure) {
        return MapDataInternal.getAssociatedType(structure);
    }

    public static class_6880<MLMapDecorationType<?, ?>> getDecorationFoStructure(class_1937 level, class_6880<class_3195> structure) {
        return MapDataInternal.getDecorationFoStructure(level, structure);
    }

    public static class_2378<MLMapDecorationType<?, ?>> getMapDecorationRegistry(class_5455 registryAccess) {
        return MapDataInternal.getMapDecorationRegistry(registryAccess);
    }

    public static class_2378<CustomMapData.Type<?, ?>> getMapDataRegistry() {
        return MapDataInternal.getMapDataRegistry();
    }

    @Deprecated(forRemoval = true)
    public static class_2378<MLMapDecorationType<?, ?>> getRegistry(class_5455 registryAccess) {
        return MapDataInternal.getRegistry(registryAccess);
    }

    @Deprecated(forRemoval = true)
    public static MLMapDecorationType<?, ?> getOrDefault(class_2960 id) {
        return MapDataInternal.getOrDefault(id);
    }

    @Deprecated(forRemoval = true)
    public static Optional<MLMapDecorationType<?, ?>> getOptional(class_2960 id) {
        return MapDataInternal.getOptional(id);
    }

    @Deprecated(forRemoval = true)
    @Nullable
    public static class_6880<MLMapDecorationType<?, ?>> getHolder(class_2960 id) {
        return MapDataInternal.getHolder(id);
    }


    @Deprecated(forRemoval = true)
    public static MLMapDecorationType<?, ?> getDefaultType() {
        return MapDataInternal.getGenericStructure();
    }
}
