package net.mehvahdjukaar.moonlight.api.map.client;

import com.google.common.collect.Maps;
import net.mehvahdjukaar.moonlight.api.map.MapDataRegistry;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecorationType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.minecraft.class_1921;
import net.minecraft.class_22;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

import java.util.Map;
import java.util.function.Function;

public class MapDecorationClientManager {

    public static final class_2960 LOCATION_MAP_MARKERS = class_2960.method_60656("textures/atlas/map_decorations.png");
    public static final class_1921 MAP_MARKERS_RENDER_TYPE = class_1921.method_23028(LOCATION_MAP_MARKERS);

    public MapDecorationClientManager() {
    }

    /**
     * Registers a renderer for this decoration. Use it to add fancy ones
     */
    public static <T extends MLMapDecoration> void registerCustomRenderer(class_2960 typeFactoryId, Function<class_2960, MapDecorationRenderer<T>> renderer) {
        CUSTOM_RENDERERS_FACTORIES.put(typeFactoryId, (Function<class_2960, MapDecorationRenderer<?>>) (Object) renderer);
    }

    private static final Map<class_2960, Function<class_2960, MapDecorationRenderer<?>>> CUSTOM_RENDERERS_FACTORIES = Maps.newHashMap();

    private static final Map<MLMapDecorationType<?, ?>, MapDecorationRenderer<?>> RENDERERS = Maps.newHashMap();

    private static MapDecorationRenderer<?> createRenderer(class_6880<MLMapDecorationType<?, ?>> type) {
        class_2960 id = type.method_40230().get().method_29177();
        var custom = CUSTOM_RENDERERS_FACTORIES.get(type.comp_349().getCustomFactoryID());
        if (custom != null) return custom.apply(id);
        else return new MapDecorationRenderer<>(id);
    }


    public static <E extends MLMapDecoration> MapDecorationRenderer<E> getRenderer(E decoration) {
        return getRenderer(decoration.getType());
    }

    @Deprecated(forRemoval = true)
    public static <E extends MLMapDecoration, T extends MLMapDecorationType<E, ?>> MapDecorationRenderer<E> getRenderer(T type) {
        return getRenderer(MapDataInternal.hackyGetRegistry().method_47983(type));
    }

    public static <E extends MLMapDecoration> MapDecorationRenderer<E> getRenderer(class_6880<MLMapDecorationType<?, ?>> type) {
        return (MapDecorationRenderer<E>) RENDERERS.computeIfAbsent(type.comp_349(), t -> createRenderer(type));
    }

    public static <T extends MLMapDecoration> boolean render(T decoration, class_4587 matrixStack,
                                                             class_4588 vertexBuilder,
                                                             class_4597 buffer,
                                                             @Nullable class_22 mapData,
                                                             boolean isOnFrame, int light, int index) {
        MapDecorationRenderer<T> renderer = getRenderer(decoration);
        if (renderer != null) {
            return renderer.render(decoration, matrixStack, vertexBuilder, buffer, mapData, isOnFrame, light, index);
        }
        return false;
    }

}
