package net.mehvahdjukaar.moonlight.api.map.decoration;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.mehvahdjukaar.moonlight.api.misc.TriFunction;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

// Equivalent of TileEntityType.
// Singleton, which will be in charge of creating CustomDecoration and MapBlockMarker instances
// Used for custom implementations
public final class MLSpecialMapDecorationType<D extends MLMapDecoration, M extends MLMapMarker<D>> extends MLMapDecorationType<D, M> {

    static final Codec<MLSpecialMapDecorationType<?, ?>> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            class_2960.field_25139.fieldOf("custom_type").forGetter(MLSpecialMapDecorationType::getCustomFactoryID)
    ).apply(instance, MapDataInternal::createCustomType));

    @ApiStatus.Internal
    public class_2960 factoryID;


    //creates marker from world
    @Nullable
    private final TriFunction<class_6880<MLMapDecorationType<?, ?>>, class_1922, class_2338, M> markerFromWorldFactory;

    /**
     * Normal constructor for a decoration type that has a world marker associated. i.e: banners
     *
     * @param markerFromWorldFactory function that retrieves an optional world marker from the world at a certain pos
     * @param decorationCodec        read decoration data from buffer
     */
    private MLSpecialMapDecorationType(MapCodec<M> markerCodec,
                                       class_9139<class_9129, D> decorationCodec,
                                       @Nullable TriFunction<class_6880<MLMapDecorationType<?, ?>>, class_1922, class_2338, M> markerFromWorldFactory) {
        super(markerCodec, decorationCodec);
        this.markerFromWorldFactory = markerFromWorldFactory;
    }

    /**
     * Use for decoration that is tied to an in world block (represented by their marker)
     */
    public static <D extends MLMapDecoration, M extends MLMapMarker<D>> MLSpecialMapDecorationType<D, M> fromWorldCustomMarker(
            MapCodec<M> markerCodec,
            class_9139<class_9129, D> decorationCodec,
            TriFunction<class_6880<MLMapDecorationType<?, ?>>, class_1922, class_2338, M> markerFromWorldFactory) {
        return new MLSpecialMapDecorationType<>(markerCodec, decorationCodec, markerFromWorldFactory);
    }

    public static MLSpecialMapDecorationType<MLMapDecoration, SimpleMapMarker> fromWorldSimple(
            TriFunction<class_6880<MLMapDecorationType<?, ?>>, class_1922, class_2338, SimpleMapMarker> markerFromWorldFactory) {
        return fromWorldCustomMarker(SimpleMapMarker.DIRECT_CODEC, MLMapDecoration.DIRECT_CODEC, markerFromWorldFactory);
    }

    /**
     * For persistent decoration that is not associated to a world block. Still have a marker as they need to be saved
     */
    public static <D extends MLMapDecoration, M extends MLMapMarker<D>> MLSpecialMapDecorationType<D, M> standaloneCustomMarker(
            MapCodec<M> markerCodec,
            class_9139<class_9129, D> decorationCode) {
        return new MLSpecialMapDecorationType<>(markerCodec, decorationCode, null);
    }

    @Override
    public boolean isFromWorld() {
        return markerFromWorldFactory != null;
    }

    @Override
    @Nullable
    public M createMarkerFromWorld(class_1922 reader, class_2338 pos) {
        return markerFromWorldFactory != null ? markerFromWorldFactory.apply(wrapAsHolder(), reader, pos) : null;
    }

    @Override
    public class_2960 getCustomFactoryID() {
        return factoryID;
    }
}
