package net.mehvahdjukaar.moonlight.api.misc;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5455;

/**
 * Used to parse objects with registry codecs
 */
@Deprecated(forRemoval = true)
public abstract class RegistryAccessJsonReloadListener extends class_4309 {

    private static final List<RegistryAccessJsonReloadListener> INSTANCES = Collections.synchronizedList(new ArrayList<>());;

    @ApiStatus.Internal
    public static void runReloads(class_5455 access){
        for(var v : INSTANCES){
            if(v.jsonMap != null) {
                v.parse(v.jsonMap, access);
                v.jsonMap = null;
            }
        }
    }

    @Nullable
    private Map<class_2960, JsonElement> jsonMap;

    protected RegistryAccessJsonReloadListener(Gson gson, String string) {
        super(gson, string);
        INSTANCES.add(this);
    }

    @Override
    protected void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profiler) {
        this.jsonMap = object;
    }

    public abstract void parse(Map<class_2960, JsonElement> jsonMap, class_5455 access);

}
